/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.summarize;

import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.summarize.TextUnit;
import dragon.ir.summarize.TopicSummary;
import dragon.matrix.vector.DoubleVector;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.onlinedb.Article;
import dragon.util.SortedArray;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractSentenceSum {
    protected String buildSummary(IndexReader indexReader, ArrayList sentSet, int summaryLength, DoubleVector weightVector) {
        IRDoc curDoc;
        int i;
        int curLength = 0;
        TopicSummary summary = new TopicSummary(3);
        ArrayList<IRDoc> list = new ArrayList<IRDoc>(sentSet.size());
        for (i = 0; i < sentSet.size(); ++i) {
            curDoc = (IRDoc)sentSet.get(i);
            curDoc.setWeight(weightVector.get(i));
            list.add(curDoc);
        }
        Collections.sort(list, new WeightComparator(true));
        for (i = 0; i < list.size() && curLength < summaryLength; ++i) {
            String curSentence;
            curDoc = (IRDoc)list.get(i);
            Article article = indexReader.getOriginalDoc(curDoc.getIndex());
            if (article == null || (curSentence = article.getTitle()) == null || summary.contains(new TextUnit(curSentence)) || curLength >= summaryLength) continue;
            summary.addText(new TextUnit(curSentence, curDoc.getIndex(), curDoc.getWeight()));
            curLength += curSentence.length();
        }
        summary.sortByWegiht();
        if (summary.size() == 0) {
            return null;
        }
        StringBuffer autoSum = new StringBuffer(summary.getTextUnit(0).getText());
        for (i = 1; i < summary.size(); ++i) {
            autoSum.append("\n");
            autoSum.append(summary.getTextUnit(i).getText());
        }
        if (autoSum.length() <= summaryLength) {
            return autoSum.toString();
        }
        return autoSum.substring(0, summaryLength);
    }

    protected String buildSummary(IndexReader indexReader, ArrayList sentSet, int summaryLength, DoubleVector weightVector, DocClusterSet clusters) {
        String curSentence;
        Article article;
        IRDoc curDoc;
        int i;
        SortedArray list = new SortedArray(sentSet.size(), new IndexComparator());
        for (i = 0; i < sentSet.size(); ++i) {
            curDoc = (IRDoc)sentSet.get(i);
            curDoc.setWeight(weightVector.get(i));
            list.add(curDoc);
        }
        for (i = 0; i < clusters.getClusterNum(); ++i) {
            DocCluster curCluster = clusters.getDocCluster(i);
            for (int j = 0; j < curCluster.getDocNum(); ++j) {
                curDoc = curCluster.getDoc(j);
                int pos = list.binarySearch(curDoc);
                if (pos < 0) continue;
                curDoc = (IRDoc)list.get(pos);
                curDoc.setCategory(i);
            }
        }
        list.setComparator(new WeightComparator(true));
        boolean[] usedDoc = new boolean[list.size()];
        boolean[] usedCluster = new boolean[clusters.getClusterNum()];
        int curLength = 0;
        TopicSummary summary = new TopicSummary(3);
        for (i = 0; i < list.size() && curLength < summaryLength; ++i) {
            curDoc = (IRDoc)list.get(i);
            if (usedCluster[curDoc.getCategory()] || (article = indexReader.getOriginalDoc(curDoc.getIndex())) == null || (curSentence = article.getTitle()) == null || summary.contains(new TextUnit(curSentence)) || curLength >= summaryLength) continue;
            summary.addText(new TextUnit(curSentence, curDoc.getIndex(), curDoc.getWeight()));
            curLength += curSentence.length();
            usedCluster[curDoc.getCategory()] = true;
            usedDoc[i] = true;
        }
        for (i = 0; i < list.size() && curLength < summaryLength; ++i) {
            if (usedDoc[i] || (article = indexReader.getOriginalDoc((curDoc = (IRDoc)list.get(i)).getIndex())) == null || (curSentence = article.getTitle()) == null || summary.contains(new TextUnit(curSentence)) || curLength >= summaryLength) continue;
            summary.addText(new TextUnit(curSentence, curDoc.getIndex(), curDoc.getWeight()));
            curLength += curSentence.length();
            usedDoc[i] = true;
        }
        summary.sortByWegiht();
        if (summary.size() == 0) {
            return null;
        }
        StringBuffer autoSum = new StringBuffer(summary.getTextUnit(0).getText());
        for (i = 1; i < summary.size(); ++i) {
            autoSum.append("\n");
            autoSum.append(summary.getTextUnit(i).getText());
        }
        if (autoSum.length() <= summaryLength) {
            return autoSum.toString();
        }
        return autoSum.substring(0, summaryLength);
    }
}

