/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.smooth.AbstractSmoother;

public class TFIDFSmoother
extends AbstractSmoother {
    private int docNum;
    private double curTermIDF;
    private double curDocLengthRatio;
    private double avgDocLength;
    private double bm25k1;
    private double bm25b;
    private double param1;
    private double param2;
    private boolean useBM25;

    public TFIDFSmoother(IRCollection collection) {
        this.docNum = collection.getDocNum();
        this.useLog = false;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = true;
        this.useBM25 = false;
    }

    public TFIDFSmoother(IRCollection collection, double bm25k1, double bm25b) {
        this.docNum = collection.getDocNum();
        this.avgDocLength = (double)collection.getTermCount() * 1.0 / (double)this.docNum;
        this.bm25b = bm25b;
        this.bm25k1 = bm25k1;
        this.useBM25 = true;
        this.useLog = false;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = true;
        this.param1 = bm25k1 * (1.0 - bm25b);
        this.param2 = bm25k1 * bm25b;
    }

    @Override
    public boolean setParameters(double[] params) {
        if (params != null && params.length >= 2) {
            this.bm25k1 = params[0];
            this.bm25b = params[1];
            this.param1 = this.bm25k1 * (1.0 - this.bm25b);
            this.param2 = this.bm25k1 * this.bm25b;
            return true;
        }
        return false;
    }

    @Override
    public void setQueryTerm(SimpleTermPredicate queryTerm) {
        this.queryWeight = queryTerm.getWeight();
        this.curTermIDF = Math.log((double)(1 + this.docNum) / (0.5 + (double)queryTerm.getDocFrequency()));
    }

    @Override
    public void setDoc(IRDoc doc) {
        if (this.useBM25) {
            this.curDocLengthRatio = this.param2 * (double)doc.getTermCount() / this.avgDocLength;
        }
    }

    @Override
    protected double computeSmoothedProb(int termFrequency) {
        if (this.useBM25) {
            return this.queryWeight * (double)termFrequency * this.curTermIDF / (this.param1 + this.curDocLengthRatio + (double)termFrequency);
        }
        return this.queryWeight * (double)termFrequency * this.curTermIDF;
    }
}

