/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.smooth.AbstractSmoother;
import dragon.ir.search.smooth.Smoother;
import dragon.matrix.Cell;
import dragon.matrix.DoubleSparseMatrix;

public class QueryFirstTransSmoother
extends AbstractSmoother {
    private IndexReader srcIndexReader;
    private IndexReader destIndexReader;
    private DoubleSparseMatrix transMatrix;
    private Smoother basicSmoother;
    private boolean relationTrans;
    private double transCoefficient;
    private int docNum;
    private int[] arrDocCount;
    private int curDocIndex;
    private double[] arrTrans;

    public QueryFirstTransSmoother(IndexReader reader, DoubleSparseMatrix transposedTransMatrix, boolean relationTrans, double transCoefficient, Smoother basicSmoother) {
        this.srcIndexReader = reader;
        this.destIndexReader = reader;
        this.transMatrix = transposedTransMatrix;
        this.relationTrans = relationTrans;
        this.useLog = true;
        this.docFirstOptimal = false;
        this.querytermFirstOptimal = true;
        this.basicSmoother = basicSmoother;
        basicSmoother.setLogLikelihoodOption(false);
        this.transCoefficient = transCoefficient;
        this.docNum = this.destIndexReader.getCollection().getDocNum();
        this.arrTrans = new double[this.docNum];
        this.arrDocCount = new int[this.docNum];
        for (int i = 0; i < this.docNum; ++i) {
            this.arrDocCount[i] = relationTrans ? this.srcIndexReader.getDoc(i).getRelationCount() : this.srcIndexReader.getDoc(i).getTermCount();
            if (this.arrDocCount[i] > 0) continue;
            this.arrDocCount[i] = 1;
        }
    }

    public QueryFirstTransSmoother(IndexReader srcIndexReader, IndexReader destIndexReader, DoubleSparseMatrix transposedTransMatrix, double transCoefficient, Smoother basicSmoother) {
        if (srcIndexReader.getCollection().getDocNum() != destIndexReader.getCollection().getDocNum()) {
            return;
        }
        this.srcIndexReader = srcIndexReader;
        this.destIndexReader = destIndexReader;
        this.transMatrix = transposedTransMatrix;
        this.relationTrans = false;
        this.useLog = true;
        this.docFirstOptimal = false;
        this.querytermFirstOptimal = true;
        this.basicSmoother = basicSmoother;
        basicSmoother.setLogLikelihoodOption(false);
        this.transCoefficient = transCoefficient;
        this.docNum = destIndexReader.getCollection().getDocNum();
        this.arrTrans = new double[this.docNum];
        this.arrDocCount = new int[this.docNum];
        for (int i = 0; i < this.docNum; ++i) {
            this.arrDocCount[i] = this.relationTrans ? srcIndexReader.getDoc(i).getRelationCount() : srcIndexReader.getDoc(i).getTermCount();
            if (this.arrDocCount[i] > 0) continue;
            this.arrDocCount[i] = 1;
        }
    }

    public void setTranslationMatrix(DoubleSparseMatrix transposedTransMatrix) {
        this.transMatrix = transposedTransMatrix;
    }

    public DoubleSparseMatrix getTranslationMatrix() {
        return this.transMatrix;
    }

    @Override
    public boolean setParameters(double[] params) {
        if (params != null && params.length >= 1) {
            this.transCoefficient = params[0];
            return true;
        }
        return false;
    }

    public Smoother getBasicSmoother() {
        return this.basicSmoother;
    }

    public double getTranslationCoefficient() {
        return this.transCoefficient;
    }

    @Override
    public void setQueryTerm(SimpleTermPredicate queryTerm) {
        int j;
        this.queryWeight = queryTerm.getWeight();
        this.basicSmoother.setQueryTerm(queryTerm);
        for (j = 0; j < this.docNum; ++j) {
            this.arrTrans[j] = 0.0;
        }
        int num = this.transMatrix.getNonZeroNumInRow(queryTerm.getIndex());
        for (j = 0; j < num; ++j) {
            int[] arrFreq;
            int[] arrIndex;
            Cell transCell = this.transMatrix.getNonZeroCellInRow(queryTerm.getIndex(), j);
            if (this.relationTrans) {
                arrIndex = this.srcIndexReader.getRelationDocIndexList(transCell.getColumn());
                arrFreq = this.srcIndexReader.getRelationDocFrequencyList(transCell.getColumn());
            } else {
                arrIndex = this.srcIndexReader.getTermDocIndexList(transCell.getColumn());
                arrFreq = this.srcIndexReader.getTermDocFrequencyList(transCell.getColumn());
            }
            for (int k = 0; k < arrIndex.length; ++k) {
                int n = arrIndex[k];
                this.arrTrans[n] = this.arrTrans[n] + transCell.getDoubleScore() * (double)arrFreq[k] / (double)this.arrDocCount[arrIndex[k]];
            }
        }
    }

    @Override
    public void setDoc(IRDoc doc) {
        this.curDocIndex = doc.getIndex();
        this.basicSmoother.setDoc(doc);
    }

    public double getTranslationProb(int docIndex) {
        return this.arrTrans[docIndex];
    }

    @Override
    protected double computeSmoothedProb(int termFrequency) {
        return this.queryWeight * this.getProb((1.0 - this.transCoefficient) * this.basicSmoother.getSmoothedProb(termFrequency) / this.queryWeight + this.transCoefficient * this.arrTrans[this.curDocIndex]);
    }
}

