/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.smooth.AbstractSmoother;

public class PivotedNormSmoother
extends AbstractSmoother {
    private int docTermCount;
    private int docNum;
    private double s;
    private double avgDocLength;
    private double idf;

    public PivotedNormSmoother(IRCollection collection) {
        this.useLog = false;
        this.s = 0.2;
        this.docNum = collection.getDocNum();
        this.avgDocLength = (double)collection.getTermCount() * 1.0 / (double)this.docNum;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = true;
    }

    public PivotedNormSmoother(IRCollection collection, double s) {
        this.useLog = false;
        this.s = s;
        this.docNum = collection.getDocNum();
        this.avgDocLength = (double)collection.getTermCount() * 1.0 / (double)this.docNum;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = true;
    }

    @Override
    public boolean setParameters(double[] params) {
        this.s = params[0];
        return true;
    }

    @Override
    public void setQueryTerm(SimpleTermPredicate queryTerm) {
        this.queryWeight = queryTerm.getWeight();
        this.idf = Math.log(((double)this.docNum + 1.0) / (double)queryTerm.getDocFrequency());
    }

    @Override
    public void setDoc(IRDoc doc) {
        this.docTermCount = doc.getTermCount();
    }

    @Override
    protected double computeSmoothedProb(int termFrequency) {
        return this.queryWeight * (1.0 + Math.log(1.0 + Math.log(termFrequency))) * this.idf / (1.0 - this.s + this.s * (double)this.docTermCount / this.avgDocLength);
    }
}

