/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IndexReader;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.smooth.AbstractSmoother;
import dragon.ir.search.smooth.Smoother;
import dragon.matrix.DoubleSparseMatrix;

public class DocFirstTransSmoother
extends AbstractSmoother {
    private IndexReader srcIndexReader;
    private IndexReader destIndexReader;
    private DoubleSparseMatrix transMatrix;
    private Smoother basicSmoother;
    private double transCoefficient;
    private boolean relationTrans;
    private int curQueryTermIndex;
    private int docSignatureCount;
    private int[] arrIndex;
    private int[] arrFreq;

    public DocFirstTransSmoother(IndexReader indexReader, DoubleSparseMatrix transMatrix, boolean relationTrans, double transCoefficient, Smoother basicSmoother) {
        this.srcIndexReader = indexReader;
        this.destIndexReader = indexReader;
        this.transMatrix = transMatrix;
        this.basicSmoother = basicSmoother;
        basicSmoother.setLogLikelihoodOption(false);
        this.relationTrans = relationTrans;
        this.useLog = true;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = false;
        this.transCoefficient = transCoefficient;
    }

    public DocFirstTransSmoother(IndexReader srcIndexReader, IndexReader destIndexReader, DoubleSparseMatrix transMatrix, double transCoefficient, Smoother basicSmoother) {
        this.srcIndexReader = srcIndexReader;
        this.destIndexReader = destIndexReader;
        this.transMatrix = transMatrix;
        this.basicSmoother = basicSmoother;
        basicSmoother.setLogLikelihoodOption(false);
        this.relationTrans = false;
        this.useLog = true;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = false;
        this.transCoefficient = transCoefficient;
    }

    @Override
    public boolean setParameters(double[] params) {
        if (params != null && params.length >= 1) {
            this.transCoefficient = params[0];
            return true;
        }
        return false;
    }

    public void setTranslationMatrix(DoubleSparseMatrix transMatrix) {
        this.transMatrix = transMatrix;
    }

    public DoubleSparseMatrix getTranslationMatrix() {
        return this.transMatrix;
    }

    public Smoother getBasicSmoother() {
        return this.basicSmoother;
    }

    public double getTranslationCoefficient() {
        return this.transCoefficient;
    }

    @Override
    public void setQueryTerm(SimpleTermPredicate queryTerm) {
        this.queryWeight = queryTerm.getWeight();
        this.curQueryTermIndex = queryTerm.getIndex();
        this.basicSmoother.setQueryTerm(queryTerm);
    }

    @Override
    public void setDoc(IRDoc curDoc) {
        this.basicSmoother.setDoc(curDoc);
        IRDoc srcDoc = this.srcIndexReader.equals(this.destIndexReader) ? curDoc : this.srcIndexReader.getDoc(curDoc.getIndex());
        if (this.relationTrans) {
            this.arrIndex = this.srcIndexReader.getRelationIndexList(curDoc.getIndex());
            this.arrFreq = this.srcIndexReader.getRelationFrequencyList(curDoc.getIndex());
            this.docSignatureCount = srcDoc.getRelationCount();
            if (this.docSignatureCount <= 0) {
                this.docSignatureCount = 1;
            }
        } else {
            this.arrIndex = this.srcIndexReader.getTermIndexList(curDoc.getIndex());
            this.arrFreq = this.srcIndexReader.getTermFrequencyList(curDoc.getIndex());
            this.docSignatureCount = srcDoc.getTermCount();
            if (this.docSignatureCount <= 0) {
                this.docSignatureCount = 1;
            }
        }
    }

    public double getTranslationProb(int termIndex) {
        if (this.transMatrix == null) {
            return this.getSelfTransProb(termIndex);
        }
        return this.getFullTransProb(termIndex);
    }

    @Override
    protected double computeSmoothedProb(int termFrequency) {
        double prob = this.transMatrix == null ? this.getSelfTransProb(this.curQueryTermIndex) : this.getFullTransProb(this.curQueryTermIndex);
        prob = this.transCoefficient * prob + (1.0 - this.transCoefficient) * this.basicSmoother.getSmoothedProb(termFrequency) / this.queryWeight;
        return this.queryWeight * this.getProb(prob);
    }

    private double getFullTransProb(int queryTermIndex) {
        double prob = 0.0;
        for (int i = 0; this.arrIndex != null && i < this.arrIndex.length; ++i) {
            prob += this.transMatrix.getDouble(this.arrIndex[i], queryTermIndex) * (double)this.arrFreq[i] / (double)this.docSignatureCount;
        }
        return prob;
    }

    private double getSelfTransProb(int queryTermIndex) {
        int count = 0;
        for (int i = 0; this.arrIndex != null && i < this.arrIndex.length; ++i) {
            IRRelation curRelation = this.srcIndexReader.getIRRelation(this.arrIndex[i]);
            if (curRelation.getFirstTerm() != queryTermIndex && curRelation.getSecondTerm() != queryTermIndex) continue;
            count += this.arrFreq[i];
        }
        return 0.5 * (double)count / (double)this.docSignatureCount;
    }
}

