/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRDoc;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.smooth.Smoother;

public abstract class AbstractSmoother
implements Smoother {
    protected boolean useLog;
    protected double queryWeight;
    protected boolean docFirstOptimal;
    protected boolean querytermFirstOptimal;

    protected abstract double computeSmoothedProb(int var1);

    @Override
    public boolean isDocFirstOptimal() {
        return this.docFirstOptimal;
    }

    @Override
    public boolean isQueryTermFirstOptimal() {
        return this.querytermFirstOptimal;
    }

    @Override
    public void setLogLikelihoodOption(boolean option) {
        this.useLog = option;
    }

    @Override
    public boolean getLogLikelihoodOption() {
        return this.useLog;
    }

    @Override
    public double getSmoothedProb(int termFreq) {
        return this.computeSmoothedProb(termFreq);
    }

    @Override
    public double getSmoothedProb(IRDoc doc, int termFreq) {
        this.setDoc(doc);
        return this.computeSmoothedProb(termFreq);
    }

    @Override
    public double getSmoothedProb(IRDoc doc) {
        this.setDoc(doc);
        return this.computeSmoothedProb(0);
    }

    @Override
    public double getSmoothedProb(SimpleTermPredicate queryTerm, int termFreq) {
        this.setQueryTerm(queryTerm);
        return this.computeSmoothedProb(termFreq);
    }

    @Override
    public double getSmoothedProb(SimpleTermPredicate queryTerm) {
        this.setQueryTerm(queryTerm);
        return this.computeSmoothedProb(0);
    }

    @Override
    public double getSmoothedProb(IRDoc doc, SimpleTermPredicate queryTerm) {
        this.setDoc(doc);
        this.setQueryTerm(queryTerm);
        return this.computeSmoothedProb(0);
    }

    @Override
    public double getSmoothedProb(IRDoc doc, SimpleTermPredicate queryTerm, int termFreq) {
        this.setDoc(doc);
        this.setQueryTerm(queryTerm);
        return this.computeSmoothedProb(termFreq);
    }

    protected double getProb(double originalProb) {
        if (this.useLog) {
            return Math.log(originalProb);
        }
        return originalProb;
    }
}

