/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.smooth.AbstractSmoother;

public class AbsoluteDiscountSmoother
extends AbstractSmoother {
    private long collectionTermCount;
    private double absoluteDiscount;
    private double collectionProb;
    private double delta;
    private int docTermCount;

    public AbsoluteDiscountSmoother(IRCollection collection, double absoluteDiscount) {
        this.collectionTermCount = collection.getTermCount();
        this.absoluteDiscount = absoluteDiscount;
        this.useLog = true;
        this.docFirstOptimal = true;
        this.querytermFirstOptimal = true;
    }

    @Override
    public boolean setParameters(double[] params) {
        if (params != null && params.length >= 1) {
            this.absoluteDiscount = params[0];
            return true;
        }
        return false;
    }

    @Override
    public void setQueryTerm(SimpleTermPredicate queryTerm) {
        this.queryWeight = queryTerm.getWeight();
        this.collectionProb = (double)queryTerm.getFrequency() / (double)this.collectionTermCount;
    }

    @Override
    public void setDoc(IRDoc doc) {
        this.docTermCount = doc.getTermCount();
        if (this.docTermCount <= 0) {
            this.docTermCount = 1;
        }
        this.delta = this.absoluteDiscount * (double)doc.getTermNum() / (double)this.docTermCount;
    }

    @Override
    protected double computeSmoothedProb(int termFreq) {
        if ((double)termFreq > this.absoluteDiscount) {
            return this.queryWeight * this.getProb(((double)termFreq - this.absoluteDiscount) / (double)this.docTermCount + this.delta * this.collectionProb);
        }
        return this.queryWeight * this.getProb(this.delta * this.collectionProb);
    }
}

