/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.AbstractFeedback;
import dragon.matrix.DoubleSparseMatrix;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class RelationTransFeedback
extends AbstractFeedback {
    DoubleSparseMatrix transMatrix;
    private int expandTermNum;
    private double bkgCoeffi;
    private boolean selfTranslation;
    private boolean generativeModel;

    public RelationTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.transMatrix = null;
        this.selfTranslation = true;
        this.generativeModel = false;
    }

    public RelationTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, DoubleSparseMatrix transMatrix) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.transMatrix = transMatrix;
        this.selfTranslation = false;
        this.generativeModel = false;
    }

    public RelationTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, double bkgCoeffi) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
        this.transMatrix = null;
        this.selfTranslation = true;
        this.generativeModel = true;
    }

    public RelationTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, double bkgCoeffi, DoubleSparseMatrix transMatrix) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
        this.transMatrix = transMatrix;
        this.selfTranslation = false;
        this.generativeModel = true;
    }

    @Override
    protected ArrayList estimateNewQueryModel(IRQuery oldQuery) {
        int i;
        int docNum;
        this.searcher.search(oldQuery);
        int n = docNum = this.feedbackDocNum < this.searcher.getRetrievedDocNum() ? this.feedbackDocNum : this.searcher.getRetrievedDocNum();
        if (docNum == 0) {
            return null;
        }
        ArrayList relationList = this.generativeModel ? this.generativeModel(docNum) : this.associationModel(docNum, oldQuery);
        SortedArray termList = this.translate(relationList);
        int predicateNum = oldQuery.getChildNum() + this.expandTermNum < termList.size() ? oldQuery.getChildNum() + this.expandTermNum : termList.size();
        ArrayList<SimpleTermPredicate> newPredicateList = new ArrayList<SimpleTermPredicate>(predicateNum);
        double weightSum = 0.0;
        for (i = 0; i < predicateNum; ++i) {
            weightSum += ((Token)termList.get(i)).getWeight();
        }
        for (i = 0; i < predicateNum; ++i) {
            Token curToken = (Token)termList.get(i);
            SimpleTermPredicate curPredicate = this.buildSimpleTermPredicate(curToken.getIndex(), curToken.getWeight() / weightSum);
            newPredicateList.add(curPredicate);
        }
        return newPredicateList;
    }

    private ArrayList associationModel(int docNum, IRQuery oldQuery) {
        Token curToken;
        int i;
        IndexReader indexReader = this.searcher.getIndexReader();
        SortedArray relationList = new SortedArray(new IndexComparator());
        SortedArray oldTermList = new SortedArray();
        for (i = 0; i < oldQuery.getChildNum(); ++i) {
            SimpleTermPredicate curPredicate = (SimpleTermPredicate)oldQuery.getChild(i);
            if (curPredicate.getDocFrequency() <= 0) continue;
            oldTermList.add(new Integer(curPredicate.getIndex()));
        }
        double weightSum = 0.0;
        for (i = 0; i < docNum; ++i) {
            IRDoc curDoc = this.searcher.getIRDoc(i);
            int[] arrRelationIndex = indexReader.getRelationIndexList(curDoc.getIndex());
            int[] arrRelationFreq = indexReader.getRelationFrequencyList(curDoc.getIndex());
            for (int j = 0; j < arrRelationIndex.length; ++j) {
                IRRelation curRelation = indexReader.getIRRelation(arrRelationIndex[j]);
                if (!oldTermList.contains(new Integer(curRelation.getFirstTerm())) && !oldTermList.contains(new Integer(curRelation.getSecondTerm()))) continue;
                curToken = new Token(null);
                curToken.setWeight(arrRelationFreq[j]);
                curToken.setIndex(arrRelationIndex[j]);
                if (!relationList.add(curToken)) {
                    Token oldToken = (Token)relationList.get(relationList.insertedPos());
                    oldToken.setWeight(oldToken.getWeight() + curToken.getWeight());
                }
                weightSum += curToken.getWeight();
            }
        }
        for (i = 0; i < relationList.size(); ++i) {
            curToken = (Token)relationList.get(i);
            curToken.setWeight(curToken.getWeight() / weightSum);
        }
        relationList.setComparator(new WeightComparator(true));
        return relationList;
    }

    private ArrayList generativeModel(int docNum) {
        Token curToken;
        int j;
        int i;
        IndexReader indexReader = this.searcher.getIndexReader();
        SortedArray relationList = new SortedArray(new IndexComparator());
        for (i = 0; i < docNum; ++i) {
            IRDoc curDoc = this.searcher.getIRDoc(i);
            int[] arrIndex = indexReader.getRelationIndexList(curDoc.getIndex());
            int[] arrFreq = indexReader.getRelationFrequencyList(curDoc.getIndex());
            for (j = 0; j < arrIndex.length; ++j) {
                curToken = new Token(null);
                curToken.setIndex(arrIndex[j]);
                curToken.setFrequency(arrFreq[j]);
                if (relationList.add(curToken)) continue;
                ((Token)relationList.get(relationList.insertedPos())).addFrequency(curToken.getFrequency());
            }
        }
        int iterationNum = 15;
        double[] arrProb = new double[relationList.size()];
        double[] arrCollectionProb = new double[relationList.size()];
        double collectionRelationCount = indexReader.getCollection().getRelationCount();
        for (i = 0; i < relationList.size(); ++i) {
            curToken = (Token)relationList.get(i);
            curToken.setWeight(1.0 / (double)relationList.size());
            arrCollectionProb[i] = this.bkgCoeffi * (double)indexReader.getIRRelation(curToken.getIndex()).getFrequency() / collectionRelationCount;
        }
        for (i = 0; i < iterationNum; ++i) {
            double weightSum = 0.0;
            for (j = 0; j < relationList.size(); ++j) {
                curToken = (Token)relationList.get(j);
                arrProb[j] = (1.0 - this.bkgCoeffi) * curToken.getWeight() / ((1.0 - this.bkgCoeffi) * curToken.getWeight() + arrCollectionProb[j]) * (double)curToken.getFrequency();
                weightSum += arrProb[j];
            }
            for (j = 0; j < relationList.size(); ++j) {
                ((Token)relationList.get(j)).setWeight(arrProb[j] / weightSum);
            }
        }
        relationList.setComparator(new WeightComparator(true));
        return relationList;
    }

    private SortedArray translate(ArrayList relationList) {
        Token curToken;
        int i;
        IndexReader reader = this.searcher.getIndexReader();
        double[] arrWeight = new double[reader.getCollection().getTermNum()];
        for (i = 0; i < arrWeight.length; ++i) {
            arrWeight[i] = 0.0;
        }
        int relationNum = this.selfTranslation ? relationList.size() : (100 < relationList.size() ? 100 : relationList.size());
        for (i = 0; i < relationNum; ++i) {
            curToken = (Token)relationList.get(i);
            if (this.selfTranslation) {
                IRRelation curRelation = reader.getIRRelation(curToken.getIndex());
                int n = curRelation.getFirstTerm();
                arrWeight[n] = arrWeight[n] + curToken.getWeight();
                int n2 = curRelation.getSecondTerm();
                arrWeight[n2] = arrWeight[n2] + curToken.getWeight();
                continue;
            }
            int[] arrIndex = this.transMatrix.getNonZeroColumnsInRow(curToken.getIndex());
            double[] arrTransProb = this.transMatrix.getNonZeroDoubleScoresInRow(curToken.getIndex());
            if (arrIndex == null) continue;
            for (int j = 0; j < arrIndex.length; ++j) {
                int n = arrIndex[j];
                arrWeight[n] = arrWeight[n] + curToken.getWeight() * arrTransProb[j];
            }
        }
        SortedArray termList = new SortedArray(new WeightComparator(true));
        for (i = 0; i < arrWeight.length; ++i) {
            if (!(arrWeight[i] > 0.0)) continue;
            curToken = new Token(null);
            curToken.setWeight(arrWeight[i]);
            curToken.setIndex(i);
            termList.add(curToken);
        }
        return termList;
    }
}

