/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.AbstractFeedback;
import dragon.matrix.DoubleSparseMatrix;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class PhraseTransFeedback
extends AbstractFeedback {
    private IndexReader phraseIndexer;
    private DoubleSparseMatrix transMatrix;
    private int expandTermNum;
    private double bkgCoeffi;
    private boolean selfTranslation;

    public PhraseTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, IndexReader phraseIndexer, double bkgCoeffi) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
        this.transMatrix = null;
        this.phraseIndexer = phraseIndexer;
        this.selfTranslation = true;
    }

    public PhraseTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, IndexReader phraseIndexer, double bkgCoeffi, DoubleSparseMatrix transMatrix) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
        this.transMatrix = transMatrix;
        this.phraseIndexer = phraseIndexer;
        this.selfTranslation = false;
    }

    @Override
    protected ArrayList estimateNewQueryModel(IRQuery oldQuery) {
        int i;
        int docNum;
        this.searcher.search(oldQuery);
        int n = docNum = this.feedbackDocNum < this.searcher.getRetrievedDocNum() ? this.feedbackDocNum : this.searcher.getRetrievedDocNum();
        if (docNum == 0) {
            return null;
        }
        ArrayList phraseList = this.generativeModel(docNum);
        SortedArray termList = this.translate(phraseList);
        int predicateNum = oldQuery.getChildNum() + this.expandTermNum < termList.size() ? oldQuery.getChildNum() + this.expandTermNum : termList.size();
        ArrayList<SimpleTermPredicate> newPredicateList = new ArrayList<SimpleTermPredicate>(predicateNum);
        double weightSum = 0.0;
        for (i = 0; i < predicateNum; ++i) {
            weightSum += ((Token)termList.get(i)).getWeight();
        }
        for (i = 0; i < predicateNum; ++i) {
            Token curToken = (Token)termList.get(i);
            SimpleTermPredicate curPredicate = this.buildSimpleTermPredicate(curToken.getIndex(), curToken.getWeight() / weightSum);
            newPredicateList.add(curPredicate);
        }
        return newPredicateList;
    }

    private ArrayList generativeModel(int docNum) {
        Token curToken;
        int j;
        int i;
        SortedArray phraseList = new SortedArray(new IndexComparator());
        for (i = 0; i < docNum; ++i) {
            IRDoc curDoc = this.searcher.getIRDoc(i);
            int[] arrIndex = this.phraseIndexer.getTermIndexList(curDoc.getIndex());
            int[] arrFreq = this.phraseIndexer.getTermFrequencyList(curDoc.getIndex());
            for (j = 0; j < arrIndex.length; ++j) {
                curToken = new Token(null);
                curToken.setIndex(arrIndex[j]);
                curToken.setFrequency(arrFreq[j]);
                if (phraseList.add(curToken)) continue;
                ((Token)phraseList.get(phraseList.insertedPos())).addFrequency(curToken.getFrequency());
            }
        }
        int iterationNum = 15;
        double[] arrProb = new double[phraseList.size()];
        double[] arrCollectionProb = new double[phraseList.size()];
        double collectionTermCount = this.phraseIndexer.getCollection().getTermCount();
        for (i = 0; i < phraseList.size(); ++i) {
            curToken = (Token)phraseList.get(i);
            curToken.setWeight(1.0 / (double)phraseList.size());
            arrCollectionProb[i] = this.bkgCoeffi * (double)this.phraseIndexer.getIRTerm(curToken.getIndex()).getFrequency() / collectionTermCount;
        }
        for (i = 0; i < iterationNum; ++i) {
            double weightSum = 0.0;
            for (j = 0; j < phraseList.size(); ++j) {
                curToken = (Token)phraseList.get(j);
                arrProb[j] = (1.0 - this.bkgCoeffi) * curToken.getWeight() / ((1.0 - this.bkgCoeffi) * curToken.getWeight() + arrCollectionProb[j]) * (double)curToken.getFrequency();
                weightSum += arrProb[j];
            }
            for (j = 0; j < phraseList.size(); ++j) {
                ((Token)phraseList.get(j)).setWeight(arrProb[j] / weightSum);
            }
        }
        phraseList.setComparator(new WeightComparator(true));
        return phraseList;
    }

    private SortedArray translate(ArrayList phraseList) {
        Token curToken;
        int i;
        IndexReader reader = this.searcher.getIndexReader();
        double[] arrWeight = new double[reader.getCollection().getTermNum()];
        for (i = 0; i < arrWeight.length; ++i) {
            arrWeight[i] = 0.0;
        }
        int phraseNum = this.selfTranslation ? phraseList.size() : (100 < phraseList.size() ? 100 : phraseList.size());
        for (i = 0; i < phraseNum; ++i) {
            int j;
            curToken = (Token)phraseList.get(i);
            if (this.selfTranslation) {
                String curPhrase = this.phraseIndexer.getTermKey(curToken.getIndex());
                String[] arrWord = curPhrase.split(" ");
                for (j = 0; j < arrWord.length; ++j) {
                    IRTerm curTerm = reader.getIRTerm(arrWord[j]);
                    if (curTerm == null) continue;
                    int n = curTerm.getIndex();
                    arrWeight[n] = arrWeight[n] + curToken.getWeight();
                }
                continue;
            }
            int[] arrIndex = this.transMatrix.getNonZeroColumnsInRow(curToken.getIndex());
            double[] arrTransProb = this.transMatrix.getNonZeroDoubleScoresInRow(curToken.getIndex());
            if (arrIndex == null) continue;
            for (j = 0; j < arrIndex.length; ++j) {
                int n = arrIndex[j];
                arrWeight[n] = arrWeight[n] + curToken.getWeight() * arrTransProb[j];
            }
        }
        SortedArray termList = new SortedArray(new WeightComparator(true));
        for (i = 0; i < arrWeight.length; ++i) {
            if (!(arrWeight[i] > 0.0)) continue;
            curToken = new Token(null);
            curToken.setWeight(arrWeight[i]);
            curToken.setIndex(i);
            termList.add(curToken);
        }
        return termList;
    }
}

