/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.AbstractFeedback;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class MinDivergenceFeedback
extends AbstractFeedback {
    private int expandTermNum;
    private double bkgCoeffi;

    public MinDivergenceFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, double bkgCoeffi) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
    }

    @Override
    protected ArrayList estimateNewQueryModel(IRQuery oldQuery) {
        Token curToken;
        int i;
        int docNum;
        IndexReader indexReader = this.searcher.getIndexReader();
        this.searcher.search(oldQuery);
        int n = docNum = this.feedbackDocNum < this.searcher.getRetrievedDocNum() ? this.feedbackDocNum : this.searcher.getRetrievedDocNum();
        if (docNum == 0) {
            return null;
        }
        SortedArray termList = new SortedArray(new IndexComparator());
        for (i = 0; i < docNum; ++i) {
            IRDoc curDoc = this.searcher.getIRDoc(i);
            int[] arrIndex = indexReader.getTermIndexList(curDoc.getIndex());
            int[] arrFreq = indexReader.getTermFrequencyList(curDoc.getIndex());
            for (int j = 0; j < arrIndex.length; ++j) {
                curToken = new Token(null);
                curToken.setIndex(arrIndex[j]);
                curToken.setWeight(Math.log((double)arrFreq[j] * 1.0 / (double)curDoc.getTermCount()));
                if (termList.add(curToken)) continue;
                Token oldToken = (Token)termList.get(termList.insertedPos());
                oldToken.setWeight(oldToken.getWeight() + curToken.getWeight());
            }
        }
        double collectionTermCount = indexReader.getCollection().getTermCount();
        for (i = 0; i < termList.size(); ++i) {
            curToken = (Token)termList.get(i);
            double weight = curToken.getWeight() / (double)docNum - this.bkgCoeffi * (double)indexReader.getIRTerm(curToken.getIndex()).getFrequency() / collectionTermCount;
            curToken.setWeight(Math.exp(weight / (1.0 - this.bkgCoeffi)));
        }
        termList.setComparator(new WeightComparator(true));
        int predicateNum = oldQuery.getChildNum() + this.expandTermNum < termList.size() ? oldQuery.getChildNum() + this.expandTermNum : termList.size();
        ArrayList<SimpleTermPredicate> newPredicateList = new ArrayList<SimpleTermPredicate>(predicateNum);
        double weightSum = 0.0;
        for (i = 0; i < predicateNum; ++i) {
            weightSum += ((Token)termList.get(i)).getWeight();
        }
        for (i = 0; i < predicateNum; ++i) {
            curToken = (Token)termList.get(i);
            SimpleTermPredicate curPredicate = this.buildSimpleTermPredicate(curToken.getIndex(), curToken.getWeight() / weightSum);
            newPredicateList.add(curPredicate);
        }
        return newPredicateList;
    }
}

