/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.kngbase.HALSpace;
import dragon.ir.query.IRQuery;
import dragon.ir.search.Searcher;
import dragon.ir.search.expand.InformationFlowQE;
import dragon.ir.search.feedback.AbstractFeedback;
import dragon.nlp.SimpleElement;
import dragon.nlp.SimpleElementList;
import dragon.nlp.extract.TokenExtractor;
import dragon.onlinedb.Article;
import java.util.ArrayList;

public class InformationFlowFeedback
extends AbstractFeedback {
    private InformationFlowQE qe;
    private TokenExtractor te;
    private SimpleElementList vocabulary;
    private int windowSize;
    private int minFrequency;

    public InformationFlowFeedback(TokenExtractor te, Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.te = te;
        this.qe = new InformationFlowQE(searcher.getIndexReader(), expandTermNum, feedbackCoeffi);
        this.windowSize = 8;
        this.minFrequency = 25;
    }

    @Override
    protected ArrayList estimateNewQueryModel(IRQuery oldQuery) {
        return null;
    }

    public void setHALWindowSize(int size) {
        this.windowSize = size;
    }

    public int getHALWindowSize() {
        return this.windowSize;
    }

    public void setInfrequentTermThreshold(int threshold) {
        this.minFrequency = threshold;
    }

    public int getInfrequentTermThreshold() {
        return this.minFrequency;
    }

    public void setMultiplier(double multiplier) {
        this.qe.setMultiplier(multiplier);
    }

    public double getMultiplier() {
        return this.qe.getMultiplier();
    }

    public void setDominantVectorWeight(double weight) {
        this.qe.setDominantVectorWeight(weight);
    }

    public double getDominantVectorWeight() {
        return this.qe.getDominantVectorWeight();
    }

    public void setSubordinateVectorWeight(double weight) {
        this.qe.setSubordinateVectorWeight(weight);
    }

    public double getSubordinateVectorWeight() {
        return this.qe.getSubordinateVectorWeight();
    }

    public void setDominantVectorThreshold(double threshold) {
        this.qe.setDominantVectorThreshold(threshold);
    }

    public double getDominantVectorThreshold() {
        return this.qe.getDominantVectorThreshold();
    }

    public void setSubordinateVectorThreshold(double threshold) {
        this.qe.setSubordinateVectorThreshold(threshold);
    }

    public double getSubordinateVectorThreshold() {
        return this.qe.getSubordinateVectorThreshold();
    }

    @Override
    public IRQuery updateQueryModel(IRQuery oldQuery) {
        int docNum;
        this.searcher.search(oldQuery);
        int n = docNum = this.feedbackDocNum < this.searcher.getRetrievedDocNum() ? this.feedbackDocNum : this.searcher.getRetrievedDocNum();
        if (docNum == 0) {
            return oldQuery;
        }
        ArrayList<Article> articleList = new ArrayList<Article>(docNum);
        IndexReader reader = this.searcher.getIndexReader();
        for (int i = 0; i < docNum; ++i) {
            String docKey = reader.getDocKey(this.searcher.getIRDoc(i).getIndex());
            articleList.add(reader.getOriginalDoc(docKey));
        }
        if (this.vocabulary == null) {
            this.vocabulary = this.prepVocabulary(this.searcher.getIndexReader(), this.minFrequency);
        }
        HALSpace hal = new HALSpace(this.vocabulary, this.te, this.windowSize);
        hal.setShowProgress(false);
        hal.add(articleList);
        hal.finalizeData();
        this.qe.setHALSpace(hal);
        return this.qe.expand(oldQuery);
    }

    private SimpleElementList prepVocabulary(IndexReader reader, int freqThreshold) {
        SimpleElementList newList = new SimpleElementList();
        int termNum = reader.getCollection().getTermNum();
        for (int i = 0; i < termNum; ++i) {
            IRTerm curTerm = reader.getIRTerm(i);
            if (curTerm.getFrequency() < freqThreshold) continue;
            int index = curTerm.getIndex();
            String key = reader.getTermKey(index);
            newList.add(new SimpleElement(key, index));
        }
        return newList;
    }
}

