/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.AbstractFeedback;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class GenerativeFeedback
extends AbstractFeedback {
    private int expandTermNum;
    private double bkgCoeffi;

    public GenerativeFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, double bkgCoeffi) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
    }

    @Override
    protected ArrayList estimateNewQueryModel(IRQuery oldQuery) {
        double weightSum;
        Token curToken;
        int j;
        int i;
        int docNum;
        IndexReader indexReader = this.searcher.getIndexReader();
        this.searcher.search(oldQuery);
        int n = docNum = this.feedbackDocNum < this.searcher.getRetrievedDocNum() ? this.feedbackDocNum : this.searcher.getRetrievedDocNum();
        if (docNum == 0) {
            return null;
        }
        SortedArray termList = new SortedArray(new IndexComparator());
        for (i = 0; i < docNum; ++i) {
            IRDoc curDoc = this.searcher.getIRDoc(i);
            int[] arrIndex = indexReader.getTermIndexList(curDoc.getIndex());
            int[] arrFreq = indexReader.getTermFrequencyList(curDoc.getIndex());
            for (j = 0; j < arrIndex.length; ++j) {
                curToken = new Token(null);
                curToken.setIndex(arrIndex[j]);
                curToken.setFrequency(arrFreq[j]);
                if (termList.add(curToken)) continue;
                ((Token)termList.get(termList.insertedPos())).addFrequency(curToken.getFrequency());
            }
        }
        int iterationNum = 15;
        double[] arrProb = new double[termList.size()];
        double[] arrCollectionProb = new double[termList.size()];
        double collectionTermCount = indexReader.getCollection().getTermCount();
        for (i = 0; i < termList.size(); ++i) {
            curToken = (Token)termList.get(i);
            curToken.setWeight(1.0 / (double)termList.size());
            arrCollectionProb[i] = this.bkgCoeffi * (double)indexReader.getIRTerm(curToken.getIndex()).getFrequency() / collectionTermCount;
        }
        for (i = 0; i < iterationNum; ++i) {
            weightSum = 0.0;
            for (j = 0; j < termList.size(); ++j) {
                curToken = (Token)termList.get(j);
                arrProb[j] = (1.0 - this.bkgCoeffi) * curToken.getWeight() / ((1.0 - this.bkgCoeffi) * curToken.getWeight() + arrCollectionProb[j]) * (double)curToken.getFrequency();
                weightSum += arrProb[j];
            }
            for (j = 0; j < termList.size(); ++j) {
                ((Token)termList.get(j)).setWeight(arrProb[j] / weightSum);
            }
        }
        termList.setComparator(new WeightComparator(true));
        int predicateNum = oldQuery.getChildNum() + this.expandTermNum < termList.size() ? oldQuery.getChildNum() + this.expandTermNum : termList.size();
        ArrayList<SimpleTermPredicate> newPredicateList = new ArrayList<SimpleTermPredicate>(predicateNum);
        weightSum = 0.0;
        for (i = 0; i < predicateNum; ++i) {
            weightSum += ((Token)termList.get(i)).getWeight();
        }
        for (i = 0; i < predicateNum; ++i) {
            curToken = (Token)termList.get(i);
            SimpleTermPredicate curPredicate = this.buildSimpleTermPredicate(curToken.getIndex(), curToken.getWeight() / weightSum);
            newPredicateList.add(curPredicate);
        }
        return newPredicateList;
    }
}

