/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRTerm;
import dragon.ir.query.IRQuery;
import dragon.ir.query.Operator;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleExpression;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.Feedback;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public abstract class AbstractFeedback
implements Feedback {
    protected int feedbackDocNum;
    protected Searcher searcher;
    protected double feedbackCoeffi;

    protected abstract ArrayList estimateNewQueryModel(IRQuery var1);

    public AbstractFeedback(Searcher searcher, int feedbackDocNum, double feedbackCoeffi) {
        this.searcher = searcher;
        this.feedbackDocNum = feedbackDocNum;
        this.feedbackCoeffi = feedbackCoeffi;
    }

    @Override
    public int getFeedbackDocNum() {
        return this.feedbackDocNum;
    }

    @Override
    public void setFeedbackDocNum(int docNum) {
        this.feedbackDocNum = docNum;
    }

    @Override
    public Searcher getSearcher() {
        return this.searcher;
    }

    @Override
    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public IRQuery updateQueryModel(IRQuery oldQuery) {
        SimpleTermPredicate curPredicate;
        int i;
        ArrayList newTermList = this.estimateNewQueryModel(oldQuery);
        if (newTermList == null || newTermList.size() == 0) {
            return oldQuery;
        }
        int termNum = newTermList.size();
        SortedArray oldTermList = new SortedArray(new IndexComparator());
        double weightSum = 0.0;
        for (i = 0; i < oldQuery.getChildNum(); ++i) {
            curPredicate = ((SimpleTermPredicate)oldQuery.getChild(i)).copy();
            if (curPredicate.getDocFrequency() <= 0) continue;
            oldTermList.add(curPredicate);
            weightSum += curPredicate.getWeight();
        }
        for (i = 0; i < oldTermList.size(); ++i) {
            curPredicate = (SimpleTermPredicate)oldTermList.get(i);
            curPredicate.setWeight(curPredicate.getWeight() / weightSum * (1.0 - this.feedbackCoeffi));
        }
        for (i = 0; i < newTermList.size(); ++i) {
            curPredicate = (SimpleTermPredicate)newTermList.get(i);
            curPredicate.setWeight(curPredicate.getWeight() * this.feedbackCoeffi);
            if (oldTermList.add(curPredicate)) continue;
            SimpleTermPredicate oldPredicate = (SimpleTermPredicate)oldTermList.get(oldTermList.insertedPos());
            oldPredicate.setWeight(oldPredicate.getWeight() + curPredicate.getWeight());
        }
        oldTermList.setComparator(new WeightComparator(true));
        weightSum = 0.0;
        for (i = 0; i < termNum; ++i) {
            weightSum += ((SimpleTermPredicate)oldTermList.get(i)).getWeight();
        }
        RelSimpleQuery query = new RelSimpleQuery();
        for (i = 0; i < termNum; ++i) {
            curPredicate = (SimpleTermPredicate)oldTermList.get(i);
            curPredicate.setWeight(curPredicate.getWeight() / weightSum);
            query.add(curPredicate);
        }
        return query;
    }

    protected IRTerm buildIRTerm(SimpleTermPredicate predicate) {
        IRTerm cur = new IRTerm(predicate.getIndex(), predicate.getFrequency(), predicate.getDocFrequency());
        cur.setKey(predicate.getKey());
        return cur;
    }

    protected SimpleTermPredicate buildSimpleTermPredicate(int termIndex, double queryWeight) {
        IRTerm curTerm = this.searcher.getIndexReader().getIRTerm(termIndex);
        SimpleTermPredicate predicate = new SimpleTermPredicate(new SimpleExpression("TERM", new Operator("="), curTerm.getKey()));
        predicate.setWeight(queryWeight);
        predicate.setFrequency(curTerm.getFrequency());
        predicate.setDocFrequency(curTerm.getDocFrequency());
        predicate.setIndex(termIndex);
        return predicate;
    }
}

