/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.expand;

import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.Operator;
import dragon.ir.query.Predicate;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleExpression;
import dragon.ir.query.SimpleTermPredicate;
import dragon.nlp.compare.IndexComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class AbstractQE {
    IndexReader indexReader;

    public AbstractQE(IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    protected SimpleTermPredicate[] checkSimpleTermQuery(RelSimpleQuery query) {
        int i;
        ArrayList<SimpleTermPredicate> list = new ArrayList<SimpleTermPredicate>();
        for (i = 0; i < query.getChildNum(); ++i) {
            IRTerm curIRTerm;
            if (!((Predicate)query.getChild(i)).isTermPredicate()) continue;
            SimpleTermPredicate predicate = (SimpleTermPredicate)query.getChild(i);
            if (predicate.getDocFrequency() <= 0 && (curIRTerm = this.indexReader.getIRTerm(predicate.getKey())) != null) {
                predicate.setDocFrequency(curIRTerm.getDocFrequency());
                predicate.setFrequency(curIRTerm.getFrequency());
                predicate.setIndex(curIRTerm.getIndex());
            }
            if (predicate.getDocFrequency() <= 0) continue;
            list.add(predicate);
        }
        SimpleTermPredicate[] arrPredicate = new SimpleTermPredicate[list.size()];
        for (i = 0; i < list.size(); ++i) {
            arrPredicate[i] = ((SimpleTermPredicate)list.get(i)).copy();
        }
        return arrPredicate;
    }

    protected SimpleTermPredicate buildSimpleTermPredicate(int termIndex, double queryWeight) {
        IRTerm curTerm = this.indexReader.getIRTerm(termIndex);
        SimpleTermPredicate predicate = new SimpleTermPredicate(new SimpleExpression("TERM", new Operator("="), curTerm.getKey()));
        predicate.setWeight(queryWeight);
        predicate.setFrequency(curTerm.getFrequency());
        predicate.setDocFrequency(curTerm.getDocFrequency());
        predicate.setIndex(termIndex);
        return predicate;
    }

    protected IRQuery buildQuery(SimpleTermPredicate[] oldQuery, SimpleTermPredicate[] newQuery, double expandCoeffi) {
        int i;
        RelSimpleQuery query = new RelSimpleQuery();
        SortedArray list = new SortedArray(new IndexComparator());
        this.normalizeQuery(oldQuery);
        this.normalizeQuery(newQuery);
        for (i = 0; i < oldQuery.length; ++i) {
            oldQuery[i].setWeight(oldQuery[i].getWeight() * (1.0 - expandCoeffi));
            list.add(oldQuery[i]);
        }
        for (i = 0; i < newQuery.length; ++i) {
            newQuery[i].setWeight(newQuery[i].getWeight() * expandCoeffi);
            if (list.add(newQuery[i])) continue;
            double weight = ((SimpleTermPredicate)list.get(list.insertedPos())).getWeight();
            ((SimpleTermPredicate)list.get(list.insertedPos())).setWeight(weight + newQuery[i].getWeight());
        }
        for (i = 0; i < list.size(); ++i) {
            query.add((SimpleTermPredicate)list.get(i));
        }
        return query;
    }

    private void normalizeQuery(SimpleTermPredicate[] query) {
        int i;
        double sum = 0.0;
        for (i = 0; i < query.length; ++i) {
            sum += query[i].getWeight();
        }
        for (i = 0; i < query.length; ++i) {
            query[i].setWeight(query[i].getWeight() / sum);
        }
    }
}

