/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.AbstractSearcher;
import dragon.ir.search.smooth.Smoother;
import dragon.nlp.compare.WeightComparator;
import java.util.ArrayList;
import java.util.Collections;

public class PartialRankSearcher
extends AbstractSearcher {
    public PartialRankSearcher(IndexReader indexReader, Smoother smoother) {
        super(indexReader, smoother);
    }

    @Override
    public int search(IRQuery query) {
        if (!query.isRelSimpleQuery()) {
            this.hitlist = null;
            return 0;
        }
        this.query = query;
        ArrayList<SimpleTermPredicate> queryList = new ArrayList<SimpleTermPredicate>();
        SimpleTermPredicate[] arrPredicate = this.checkSimpleTermQuery((RelSimpleQuery)query);
        if (arrPredicate == null || arrPredicate.length == 0) {
            this.hitlist = null;
            return 0;
        }
        this.hitlist = this.addDocList(new ArrayList(), queryList, this.getHitList(arrPredicate[0]), arrPredicate[0]);
        queryList.add(arrPredicate[0]);
        for (int i = 1; i < arrPredicate.length; ++i) {
            this.hitlist = this.addDocList(this.hitlist, queryList, this.getHitList(arrPredicate[i]), arrPredicate[i]);
            queryList.add(arrPredicate[i]);
        }
        Collections.sort(this.hitlist, new WeightComparator(true));
        return this.hitlist.size();
    }

    private IRDoc[] getHitList(SimpleTermPredicate predicate) {
        try {
            if (predicate == null) {
                return null;
            }
            IRDoc[] arrDoc = this.indexReader.getTermDocList(predicate.getIndex());
            int[] arrFreq = this.indexReader.getTermDocFrequencyList(predicate.getIndex());
            this.smoother.setQueryTerm(predicate);
            for (int i = 0; i < arrDoc.length; ++i) {
                arrDoc[i].setWeight(this.smoother.getSmoothedProb(arrDoc[i], arrFreq[i]));
            }
            return arrDoc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ArrayList addDocList(ArrayList hisDocList, ArrayList hisQueryList, IRDoc[] curDocList, SimpleTermPredicate curPredicate) {
        int k;
        IRDoc hisDoc;
        if (curDocList == null) {
            return hisDocList;
        }
        int i = 0;
        int j = 0;
        ArrayList<IRDoc> newList = new ArrayList<IRDoc>();
        while (i < hisDocList.size() && j < curDocList.length) {
            hisDoc = (IRDoc)hisDocList.get(i);
            if (hisDoc.getIndex() == curDocList[j].getIndex()) {
                hisDoc.setWeight(hisDoc.getWeight() + curDocList[j].getWeight());
                newList.add(hisDoc);
                ++i;
                ++j;
                continue;
            }
            if (hisDoc.getIndex() < curDocList[j].getIndex()) {
                hisDoc.setWeight(hisDoc.getWeight() + this.smoother.getSmoothedProb(hisDoc, curPredicate));
                newList.add(hisDoc);
                ++i;
                continue;
            }
            curDocList[j].setWeight(curDocList[j].getWeight() + this.computeWeight(curDocList[j], hisQueryList));
            newList.add(curDocList[j]);
            ++j;
        }
        if (j < curDocList.length) {
            for (k = j; k < curDocList.length; ++k) {
                curDocList[k].setWeight(curDocList[k].getWeight() + this.computeWeight(curDocList[k], hisQueryList));
                newList.add(curDocList[k]);
            }
        }
        if (i < hisDocList.size()) {
            for (k = i; k < hisDocList.size(); ++k) {
                hisDoc = (IRDoc)hisDocList.get(k);
                hisDoc.setWeight(hisDoc.getWeight() + this.smoother.getSmoothedProb(hisDoc, curPredicate));
                newList.add(hisDoc);
            }
        }
        return newList;
    }

    private double computeWeight(IRDoc doc, ArrayList hisQueryList) {
        double weight = 0.0;
        this.smoother.setDoc(doc);
        for (int i = 0; i < hisQueryList.size(); ++i) {
            weight += this.smoother.getSmoothedProb((SimpleTermPredicate)hisQueryList.get(i));
        }
        return weight;
    }
}

