/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.AbstractSearcher;
import dragon.ir.search.smooth.Smoother;
import dragon.nlp.compare.WeightComparator;
import java.util.ArrayList;
import java.util.Collections;

public class FullRankSearcher
extends AbstractSearcher {
    private boolean docFirst;

    public FullRankSearcher(IndexReader indexReader, Smoother smoother) {
        super(indexReader, smoother);
        smoother.setLogLikelihoodOption(true);
        this.docFirst = !smoother.isQueryTermFirstOptimal();
    }

    public FullRankSearcher(IndexReader indexReader, Smoother smoother, boolean docFirst) {
        super(indexReader, smoother);
        smoother.setLogLikelihoodOption(true);
        this.docFirst = docFirst;
    }

    @Override
    public int search(IRQuery query) {
        this.query = query;
        if (this.docFirst) {
            return this.breadthFirstSearch(query);
        }
        return this.depthFirstSearch(query);
    }

    public int breadthFirstSearch(IRQuery query) {
        if (!query.isRelSimpleQuery()) {
            this.hitlist = null;
            return 0;
        }
        int docNum = this.indexReader.getCollection().getDocNum();
        this.hitlist = new ArrayList(docNum);
        SimpleTermPredicate[] arrPredicate = this.checkSimpleTermQuery((RelSimpleQuery)query);
        if (arrPredicate == null || arrPredicate.length == 0) {
            this.hitlist = null;
            return 0;
        }
        for (int i = 0; i < docNum; ++i) {
            IRDoc curDoc = this.indexReader.getDoc(i);
            this.smoother.setDoc(curDoc);
            double weight = 0.0;
            for (int j = 0; j < arrPredicate.length; ++j) {
                IRTerm curTerm = this.indexReader.getIRTerm(arrPredicate[j].getIndex(), i);
                if (curTerm != null) {
                    weight += this.smoother.getSmoothedProb(arrPredicate[j], curTerm.getFrequency());
                    continue;
                }
                weight += this.smoother.getSmoothedProb(arrPredicate[j]);
            }
            curDoc.setWeight(weight);
            this.hitlist.add(curDoc);
        }
        Collections.sort(this.hitlist, new WeightComparator(true));
        return this.hitlist.size();
    }

    public int depthFirstSearch(IRQuery query) {
        int i;
        if (!query.isRelSimpleQuery()) {
            this.hitlist = null;
            return 0;
        }
        int docNum = this.indexReader.getCollection().getDocNum();
        this.hitlist = new ArrayList(docNum);
        SimpleTermPredicate[] arrPredicate = this.checkSimpleTermQuery((RelSimpleQuery)query);
        if (arrPredicate == null || arrPredicate.length == 0) {
            this.hitlist = null;
            return 0;
        }
        IRDoc[] arrDoc = new IRDoc[docNum];
        for (i = 0; i < docNum; ++i) {
            arrDoc[i] = this.indexReader.getDoc(i);
            arrDoc[i].setWeight(0.0);
        }
        for (i = 0; i < arrPredicate.length; ++i) {
            this.smoother.setQueryTerm(arrPredicate[i]);
            int[] arrIndex = this.indexReader.getTermDocIndexList(arrPredicate[i].getIndex());
            int[] arrFreq = this.indexReader.getTermDocFrequencyList(arrPredicate[i].getIndex());
            int k = 0;
            for (int j = 0; j < arrIndex.length; ++j) {
                while (k < arrIndex[j]) {
                    arrDoc[k].setWeight(arrDoc[k].getWeight() + this.smoother.getSmoothedProb(arrDoc[k]));
                    ++k;
                }
                arrDoc[k].setWeight(arrDoc[k].getWeight() + this.smoother.getSmoothedProb(arrDoc[k], arrFreq[j]));
                ++k;
            }
            while (k < docNum) {
                arrDoc[k].setWeight(arrDoc[k].getWeight() + this.smoother.getSmoothedProb(arrDoc[k]));
                ++k;
            }
        }
        for (i = 0; i < docNum; ++i) {
            this.hitlist.add(arrDoc[i]);
        }
        Collections.sort(this.hitlist, new WeightComparator(true));
        return this.hitlist.size();
    }
}

