/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.AbstractSearcher;
import dragon.ir.search.smooth.Smoother;
import dragon.nlp.compare.WeightComparator;
import java.util.ArrayList;
import java.util.Collections;

public class BoolRankSearcher
extends AbstractSearcher {
    public BoolRankSearcher(IndexReader indexReader, Smoother smoother) {
        super(indexReader, smoother);
    }

    @Override
    public int search(IRQuery query) {
        if (!query.isRelBoolQuery()) {
            this.hitlist = null;
            return 0;
        }
        this.query = query;
        this.hitlist = this.getHitList(query);
        Collections.sort(this.hitlist, new WeightComparator(true));
        return this.hitlist.size();
    }

    private ArrayList getHitList(IRQuery query) {
        ArrayList list;
        if (query.isPredicate()) {
            list = this.checkSimpleTermPredicate(query) ? this.getDocList((SimpleTermPredicate)query) : null;
        } else {
            list = this.getHitList(query.getChild(0));
            for (int i = 1; i < query.getChildNum(); ++i) {
                list = query.getOperator().toString().equalsIgnoreCase("AND") ? this.addDocList(list, this.getHitList(query.getChild(i)), true) : this.addDocList(list, this.getHitList(query.getChild(i)), false);
            }
        }
        return list;
    }

    private ArrayList getDocList(SimpleTermPredicate predicate) {
        try {
            IRDoc[] arrDoc = this.indexReader.getTermDocList(predicate.getIndex());
            ArrayList<IRDoc> list = new ArrayList<IRDoc>(arrDoc.length);
            int[] arrFreq = this.indexReader.getTermDocFrequencyList(predicate.getIndex());
            this.smoother.setQueryTerm(predicate);
            for (int i = 0; i < arrDoc.length; ++i) {
                arrDoc[i].setWeight(this.smoother.getSmoothedProb(arrDoc[i], arrFreq[i]));
                list.add(arrDoc[i]);
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ArrayList addDocList(ArrayList hisDocList, ArrayList curDocList, boolean interaction) {
        int k;
        int i = 0;
        int j = 0;
        ArrayList<IRDoc> newList = new ArrayList<IRDoc>();
        while (i < hisDocList.size() && j < curDocList.size()) {
            IRDoc hisDoc = (IRDoc)hisDocList.get(i);
            IRDoc curDoc = (IRDoc)curDocList.get(j);
            if (hisDoc.getIndex() == curDoc.getIndex()) {
                hisDoc.setWeight(hisDoc.getWeight() + curDoc.getWeight());
                newList.add(hisDoc);
                ++i;
                ++j;
                continue;
            }
            if (hisDoc.getIndex() < curDoc.getIndex()) {
                if (!interaction) {
                    newList.add(hisDoc);
                }
                ++i;
                continue;
            }
            if (!interaction) {
                newList.add(curDoc);
            }
            ++j;
        }
        if (j < curDocList.size() && !interaction) {
            for (k = j; k < curDocList.size(); ++k) {
                newList.add((IRDoc)curDocList.get(k));
            }
        }
        if (i < hisDocList.size() && !interaction) {
            for (k = i; k < hisDocList.size(); ++k) {
                newList.add((IRDoc)hisDocList.get(k));
            }
        }
        return newList;
    }

    private boolean checkSimpleTermPredicate(IRQuery query) {
        IRTerm curIRTerm;
        SimpleTermPredicate predicate = (SimpleTermPredicate)query;
        if (predicate.getDocFrequency() <= 0 && (curIRTerm = this.indexReader.getIRTerm(predicate.getKey())) != null) {
            predicate.setDocFrequency(curIRTerm.getDocFrequency());
            predicate.setFrequency(curIRTerm.getFrequency());
            predicate.setIndex(curIRTerm.getIndex());
        }
        return predicate.getDocFrequency() > 0;
    }
}

