/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.Predicate;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.smooth.Smoother;
import java.util.ArrayList;

public abstract class AbstractSearcher
implements Searcher {
    protected IndexReader indexReader;
    protected ArrayList hitlist;
    protected IRQuery query;
    protected Smoother smoother;
    private boolean queryWeighting;

    public AbstractSearcher(IndexReader indexReader, Smoother smoother) {
        this.indexReader = indexReader;
        this.smoother = smoother;
        this.queryWeighting = true;
    }

    protected SimpleTermPredicate[] checkSimpleTermQuery(RelSimpleQuery query) {
        int i;
        ArrayList<SimpleTermPredicate> list = new ArrayList<SimpleTermPredicate>();
        for (i = 0; i < query.getChildNum(); ++i) {
            IRTerm curIRTerm;
            if (!((Predicate)query.getChild(i)).isTermPredicate()) continue;
            SimpleTermPredicate predicate = (SimpleTermPredicate)query.getChild(i);
            if (predicate.getDocFrequency() <= 0 && (curIRTerm = this.indexReader.getIRTerm(predicate.getKey())) != null) {
                predicate.setDocFrequency(curIRTerm.getDocFrequency());
                predicate.setFrequency(curIRTerm.getFrequency());
                predicate.setIndex(curIRTerm.getIndex());
            }
            if (predicate.getDocFrequency() <= 0) continue;
            list.add(predicate);
        }
        SimpleTermPredicate[] arrPredicate = new SimpleTermPredicate[list.size()];
        for (i = 0; i < list.size(); ++i) {
            arrPredicate[i] = ((SimpleTermPredicate)list.get(i)).copy();
            if (this.queryWeighting) continue;
            arrPredicate[i].setWeight(1.0);
        }
        return arrPredicate;
    }

    @Override
    public IRDoc getIRDoc(int ranking) {
        return (IRDoc)this.hitlist.get(ranking);
    }

    @Override
    public ArrayList getRankedDocumentList() {
        return this.hitlist;
    }

    @Override
    public int getRetrievedDocNum() {
        return this.hitlist.size();
    }

    @Override
    public Smoother getSmoother() {
        return this.smoother;
    }

    @Override
    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    @Override
    public IRQuery getQuery() {
        return this.query;
    }

    @Override
    public void setQueryWeightingOption(boolean option) {
        this.queryWeighting = option;
    }

    @Override
    public boolean getQueryWeightingOption() {
        return this.queryWeighting;
    }
}

