/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.query;

import dragon.ir.query.AbstractPredicate;
import dragon.ir.query.SimpleExpression;
import dragon.nlp.compare.SortedElement;

public class SimpleTermPredicate
extends AbstractPredicate
implements SortedElement {
    private int termFrequency;
    private int index;
    private int docFrequency;

    public SimpleTermPredicate(String[] predicate) {
        this.parse(predicate);
    }

    public SimpleTermPredicate(SimpleExpression constraint) {
        this.predicateType = 1;
        this.expressionType = 1;
        this.constraint = constraint;
    }

    @Override
    protected void parse(String[] predicate) {
        this.predicateType = 1;
        this.expressionType = 1;
        this.constraint = new SimpleExpression(predicate);
    }

    public SimpleTermPredicate copy() {
        SimpleTermPredicate cur = new SimpleTermPredicate((SimpleExpression)this.constraint);
        cur.setWeight(this.weight);
        cur.setIndex(this.index);
        cur.setDocFrequency(this.docFrequency);
        cur.setFrequency(this.termFrequency);
        return cur;
    }

    public String getKey() {
        return this.getTestValue();
    }

    public String getField() {
        return ((SimpleExpression)this.constraint).getField();
    }

    public String getTestValue() {
        return (String)((SimpleExpression)this.constraint).getTestValue();
    }

    @Override
    public String toSQLExpression() {
        return this.constraint.toSQLExpression();
    }

    @Override
    public String toString() {
        if (this.weight != 1.0) {
            return "T(" + String.valueOf(this.weight) + ", " + this.constraint.toString() + ")";
        }
        return "T(" + this.constraint.toString() + ")";
    }

    public int getDocFrequency() {
        return this.docFrequency;
    }

    public void setDocFrequency(int freq) {
        this.docFrequency = freq;
    }

    @Override
    public int getFrequency() {
        return this.termFrequency;
    }

    @Override
    public void setFrequency(int freq) {
        this.termFrequency = freq;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }
}

