/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.query;

import dragon.ir.query.AbstractIRQuery;
import dragon.ir.query.AbstractPredicate;
import dragon.ir.query.Operator;
import dragon.ir.query.Predicate;
import dragon.ir.query.SimpleRelationPredicate;
import dragon.ir.query.SimpleTermPredicate;
import java.util.ArrayList;

public class RelSimpleQuery
extends AbstractIRQuery {
    public RelSimpleQuery() {
        this.children = null;
        this.optr = null;
    }

    public RelSimpleQuery(String query) {
        this.parse(query);
    }

    public static void main(String[] args) {
        String expression = "R(1.0,TERM1=C0007114 AND TERM2=C0012899) T(0.3,TERM=Y0000004)";
        RelSimpleQuery query = new RelSimpleQuery(expression);
        for (int i = 0; i < query.getChildNum(); ++i) {
            System.out.println(query.toString());
        }
    }

    @Override
    public boolean isRelSimpleQuery() {
        return true;
    }

    public boolean add(Predicate predicate) {
        if (!predicate.isSimplePredicate()) {
            return false;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(predicate);
        return true;
    }

    @Override
    public String toString() {
        if (this.getChildNum() == 0) {
            return null;
        }
        if (this.getChildNum() == 1) {
            return this.getChild(0).toString();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getChildNum(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.getChild(i).toString());
        }
        return sb.toString();
    }

    @Override
    protected void parse(String[] arrToken) {
        this.optr = new Operator("OR");
        this.children = new ArrayList();
        boolean flag = false;
        int leftParenthesis = 0;
        int rightParenthesis = 0;
        int start = 0;
        for (int i = 0; i < arrToken.length; ++i) {
            String curToken = arrToken[i];
            if (curToken.equals("(")) {
                if (i >= 1 && "TMR".indexOf(arrToken[i - 1]) >= 0) {
                    start = i - 1;
                    leftParenthesis = 1;
                    rightParenthesis = 0;
                    flag = true;
                    continue;
                }
                ++leftParenthesis;
                continue;
            }
            if (!curToken.equals(")") || !flag || leftParenthesis != ++rightParenthesis) continue;
            flag = false;
            this.children.add(this.getPredicate(arrToken, start, i - start));
        }
    }

    private Predicate getPredicate(String[] expression, int start, int length) {
        AbstractPredicate predicate;
        String[] part;
        double weight;
        if (expression[start + 3].equalsIgnoreCase(",")) {
            weight = Double.parseDouble(expression[start + 2]);
            part = new String[length - 4];
            System.arraycopy(expression, start + 4, part, 0, part.length);
        } else {
            weight = 1.0;
            part = new String[length - 2];
            System.arraycopy(expression, start + 2, part, 0, part.length);
        }
        if (expression[start].equalsIgnoreCase("T")) {
            predicate = new SimpleTermPredicate(part);
        } else if (expression[start].equalsIgnoreCase("R")) {
            predicate = new SimpleRelationPredicate(part);
        } else {
            return null;
        }
        predicate.setWeight(weight);
        return predicate;
    }
}

