/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.query;

import dragon.ir.query.AbstractIRQuery;
import dragon.ir.query.AbstractPredicate;
import dragon.ir.query.BoolQualifierPredicate;
import dragon.ir.query.BoolRelationPredicate;
import dragon.ir.query.BoolTermPredicate;
import dragon.ir.query.Operator;
import dragon.ir.query.Predicate;
import java.util.ArrayList;

public class RelBoolQuery
extends AbstractIRQuery {
    public RelBoolQuery() {
        this.optr = null;
        this.children = null;
    }

    public RelBoolQuery(String[] expression) {
        this.parse(expression);
    }

    public RelBoolQuery(String expression) {
        this.parse(expression);
    }

    public static void main(String[] args) {
        String expression = "T((tui=T116 or tui=T028) and string like %aaa%)";
        RelBoolQuery query = new RelBoolQuery(expression);
        System.out.println(query.toString());
    }

    @Override
    public boolean isRelBoolQuery() {
        return true;
    }

    @Override
    protected void parse(String[] expression) {
        this.optr = null;
        this.children = new ArrayList();
        ArrayList<Integer> andList = new ArrayList<Integer>();
        int start = 0;
        int end = expression.length - 1;
        boolean found = false;
        while (!found) {
            RelBoolQuery curQuery;
            String[] part;
            int i;
            int lastOR = start - 1;
            int leftParenthesis = 0;
            int rightParenthesis = 0;
            for (i = start; i <= end; ++i) {
                if (expression[i].equalsIgnoreCase("(")) {
                    ++leftParenthesis;
                    continue;
                }
                if (expression[i].equalsIgnoreCase(")")) {
                    ++rightParenthesis;
                    continue;
                }
                if (expression[i].equalsIgnoreCase("OR")) {
                    if (leftParenthesis != rightParenthesis) continue;
                    found = true;
                    part = new String[i - lastOR - 1];
                    System.arraycopy(expression, lastOR + 1, part, 0, part.length);
                    curQuery = new RelBoolQuery(part);
                    this.children.add(curQuery);
                    lastOR = i;
                    continue;
                }
                if (!expression[i].equalsIgnoreCase("AND") || leftParenthesis != rightParenthesis) continue;
                andList.add(new Integer(i));
            }
            if (found) {
                this.optr = new Operator("OR");
                part = new String[end - lastOR];
                System.arraycopy(expression, lastOR + 1, part, 0, part.length);
                curQuery = new RelBoolQuery(part);
                this.children.add(curQuery);
                continue;
            }
            if (andList.size() >= 1) {
                found = true;
                this.optr = new Operator("AND");
                int lastAND = start - 1;
                andList.add(new Integer(end + 1));
                for (i = 0; i < andList.size(); ++i) {
                    int j = (Integer)andList.get(i);
                    part = new String[j - lastAND - 1];
                    System.arraycopy(expression, lastAND + 1, part, 0, part.length);
                    curQuery = new RelBoolQuery(part);
                    this.children.add(curQuery);
                    lastAND = j;
                }
                continue;
            }
            if (expression[start].equalsIgnoreCase("(") && expression[end].equalsIgnoreCase(")")) {
                ++start;
                --end;
                continue;
            }
            found = true;
            this.optr = new Operator("AND");
            this.children.add(this.getPredicate(expression, start, end - start));
        }
    }

    private Predicate getPredicate(String[] expression, int start, int length) {
        AbstractPredicate curPredicate;
        String[] part;
        double weight;
        if (expression[start + 3].equalsIgnoreCase(",")) {
            weight = Double.parseDouble(expression[start + 2]);
            part = new String[length - 4];
            System.arraycopy(expression, start + 4, part, 0, part.length);
        } else {
            weight = 1.0;
            part = new String[length - 2];
            System.arraycopy(expression, start + 2, part, 0, part.length);
        }
        if (expression[start].equalsIgnoreCase("T")) {
            curPredicate = new BoolTermPredicate(part);
        } else if (expression[start].equalsIgnoreCase("R")) {
            curPredicate = new BoolRelationPredicate(part);
        } else if (expression[start].equalsIgnoreCase("M")) {
            curPredicate = new BoolQualifierPredicate(part);
        } else {
            return null;
        }
        curPredicate.setWeight(weight);
        return curPredicate;
    }
}

