/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.query;

import dragon.ir.index.IRSection;
import dragon.nlp.Concept;
import dragon.nlp.Token;
import dragon.nlp.Triple;
import dragon.util.FormatUtil;
import dragon.util.SortedArray;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class QueryWriter {
    private static final int MAX_SEC = 10;
    private boolean indexConceptEntry;
    private double subtermWeight;
    private SortedArray conceptList;
    private SortedArray relationList;
    private IRSection[] arrSections;

    public QueryWriter(boolean relationSupported, boolean indexConceptEntry) {
        this.indexConceptEntry = indexConceptEntry;
        this.subtermWeight = 1.0;
        this.arrSections = new IRSection[10];
        this.conceptList = new SortedArray();
        this.relationList = new SortedArray();
    }

    public void initNewQuery() {
        this.conceptList.clear();
        this.relationList.clear();
    }

    public boolean addSection(IRSection section) {
        if (section.getSectionID() >= 10) {
            return false;
        }
        this.arrSections[section.getSectionID()] = section;
        return true;
    }

    public boolean write(int section, ArrayList conceptList) {
        if (this.arrSections[section] == null) {
            return false;
        }
        for (int i = 0; i < conceptList.size(); ++i) {
            Concept curCpt = (Concept)conceptList.get(i);
            this.addConcept(section, curCpt);
        }
        return true;
    }

    public boolean write(int section, ArrayList conceptList, ArrayList tripleList) {
        if (this.arrSections[section] == null) {
            return false;
        }
        this.write(section, conceptList);
        for (int i = 0; i < tripleList.size(); ++i) {
            Triple curTriple = (Triple)tripleList.get(i);
            this.addTriple(section, curTriple);
        }
        return true;
    }

    private void addTriple(int section, Triple triple) {
        Token first = this.indexConceptEntry ? new Token(triple.getFirstConcept().getEntryID()) : new Token(triple.getFirstConcept().getName());
        int pos = this.conceptList.binarySearch(first);
        if (pos < 0) {
            return;
        }
        first = (Token)this.conceptList.get(pos);
        Token second = this.indexConceptEntry ? new Token(triple.getSecondConcept().getEntryID()) : new Token(triple.getSecondConcept().getName());
        pos = this.conceptList.binarySearch(second);
        if (pos < 0) {
            return;
        }
        second = (Token)this.conceptList.get(pos);
        Triple cur = first.getIndex() > second.getIndex() ? new Triple(second, first) : new Triple(first, second);
        cur.setWeight(this.arrSections[section].getWeight());
        cur.setIndex(this.relationList.size());
        if (!this.relationList.add(cur)) {
            Triple old = (Triple)this.relationList.get(this.relationList.insertedPos());
            if (cur.getWeight() > old.getWeight()) {
                old.setWeight(cur.getWeight());
            }
        }
    }

    private void addConcept(int section, Concept concept) {
        Token cur = this.indexConceptEntry ? new Token(concept.getEntryID()) : new Token(concept.getName());
        cur.setWeight(this.arrSections[section].getWeight());
        if (concept.isSubConcept()) {
            cur.setWeight(cur.getWeight() * this.subtermWeight);
        }
        cur.setIndex(this.conceptList.size());
        if (!this.conceptList.add(cur)) {
            Token old = (Token)this.conceptList.get(this.conceptList.insertedPos());
            if (cur.getWeight() > old.getWeight()) {
                old.setWeight(cur.getWeight());
            }
        }
    }

    public void setSubTermWeight(double weight) {
        this.subtermWeight = weight;
    }

    public String getQuery() {
        Token curToken;
        int i;
        DecimalFormat df = FormatUtil.getNumericFormat(1, 2);
        StringBuffer query = new StringBuffer();
        for (i = 0; i < this.relationList.size(); ++i) {
            Triple curTriple = (Triple)this.relationList.get(i);
            query.append("R(");
            if (curTriple.getWeight() != 1.0) {
                query.append(df.format(curTriple.getWeight()));
                query.append(",");
            }
            query.append("TERM=");
            curToken = (Token)curTriple.getFirstConcept();
            query.append(curToken.getValue());
            query.append(" AND TERM2=");
            curToken = (Token)curTriple.getSecondConcept();
            query.append(curToken.getValue());
            query.append(") ");
        }
        for (i = 0; i < this.conceptList.size(); ++i) {
            curToken = (Token)this.conceptList.get(i);
            query.append(" T(");
            if (curToken.getWeight() != 1.0) {
                query.append(df.format(curToken.getWeight()));
                query.append(",");
            }
            query.append("TERM=");
            query.append(curToken.getValue());
            query.append(")");
        }
        return query.toString();
    }
}

