/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.query;

import dragon.ir.query.AbstractExpression;
import dragon.ir.query.Expression;
import dragon.ir.query.Operator;
import dragon.ir.query.SimpleExpression;
import java.util.ArrayList;

public class BoolExpression
extends AbstractExpression {
    private ArrayList children = new ArrayList();

    public BoolExpression(String[] expression) {
        this.expressionType = 1;
        this.parse(expression);
    }

    @Override
    public int getChildNum() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public Expression getChild(int index) {
        if (index >= this.getChildNum() || index < 0) {
            return null;
        }
        return (Expression)this.children.get(index);
    }

    @Override
    public Operator getOperator() {
        return this.optr;
    }

    @Override
    public String toSQLExpression() {
        if (this.getChildNum() == 0) {
            return null;
        }
        if (this.getChildNum() == 1) {
            return this.getChild(0).toSQLExpression();
        }
        StringBuffer buf = new StringBuffer();
        if (this.optr.toString().equalsIgnoreCase("OR")) {
            buf.append('(');
        }
        for (int i = 0; i < this.getChildNum(); ++i) {
            buf.append(this.getChild(i).toSQLExpression());
            if (i >= this.getChildNum() - 1) continue;
            buf.append(' ');
            buf.append(this.getOperator().toString());
            buf.append(' ');
        }
        if (this.optr.toString().equalsIgnoreCase("OR")) {
            buf.append(')');
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        if (this.children.size() == 1) {
            return this.getChild(0).toString();
        }
        StringBuffer buf = new StringBuffer();
        if (this.optr.toString().equalsIgnoreCase("OR")) {
            buf.append('(');
        }
        for (int i = 0; i < this.getChildNum(); ++i) {
            buf.append(this.getChild(i).toString());
            if (i >= this.getChildNum() - 1) continue;
            buf.append(' ');
            buf.append(this.getOperator().toString());
            buf.append(' ');
        }
        if (this.optr.toString().equalsIgnoreCase("OR")) {
            buf.append(')');
        }
        return buf.toString();
    }

    private void parse(String[] expression) {
        ArrayList<Integer> andList = new ArrayList<Integer>();
        int start = 0;
        int end = expression.length - 1;
        boolean found = false;
        while (!found) {
            BoolExpression curBoolExpression;
            String[] part;
            int i;
            int lastOR = start - 1;
            int leftParenthesis = 0;
            int rightParenthesis = 0;
            for (i = start; i <= end; ++i) {
                if (expression[i].equalsIgnoreCase("(")) {
                    ++leftParenthesis;
                    continue;
                }
                if (expression[i].equalsIgnoreCase(")")) {
                    ++rightParenthesis;
                    continue;
                }
                if (expression[i].equalsIgnoreCase("OR")) {
                    if (leftParenthesis != rightParenthesis) continue;
                    found = true;
                    part = new String[i - lastOR - 1];
                    System.arraycopy(expression, lastOR + 1, part, 0, part.length);
                    curBoolExpression = new BoolExpression(part);
                    this.children.add(curBoolExpression);
                    lastOR = i;
                    continue;
                }
                if (!expression[i].equalsIgnoreCase("AND") || leftParenthesis != rightParenthesis) continue;
                andList.add(new Integer(i));
            }
            if (found) {
                this.optr = new Operator("OR");
                part = new String[end - lastOR];
                System.arraycopy(expression, lastOR + 1, part, 0, part.length);
                curBoolExpression = new BoolExpression(part);
                this.children.add(curBoolExpression);
                continue;
            }
            if (andList.size() >= 1) {
                found = true;
                this.optr = new Operator("AND");
                int lastAND = start - 1;
                andList.add(new Integer(end + 1));
                for (i = 0; i < andList.size(); ++i) {
                    int j = (Integer)andList.get(i);
                    part = new String[j - lastAND - 1];
                    System.arraycopy(expression, lastAND + 1, part, 0, part.length);
                    curBoolExpression = new BoolExpression(part);
                    this.children.add(curBoolExpression);
                    lastAND = j;
                }
                continue;
            }
            if (expression[start].equalsIgnoreCase("(") && expression[end].equalsIgnoreCase(")")) {
                ++start;
                --end;
                continue;
            }
            this.optr = new Operator("AND");
            found = true;
            SimpleExpression curSimpleExpression = new SimpleExpression(expression);
            this.children.add(curSimpleExpression);
        }
    }
}

