/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.query;

import dragon.ir.query.IRQuery;
import dragon.ir.query.Operator;
import java.util.ArrayList;

public abstract class AbstractIRQuery
implements IRQuery {
    protected Operator optr;
    protected ArrayList children;
    private int queryKey;

    @Override
    public int getQueryKey() {
        return this.queryKey;
    }

    @Override
    public void setQueryKey(int key) {
        this.queryKey = key;
    }

    @Override
    public boolean isPredicate() {
        return false;
    }

    @Override
    public boolean isCompoundQuery() {
        return true;
    }

    @Override
    public boolean isRelSimpleQuery() {
        return false;
    }

    @Override
    public boolean isRelBoolQuery() {
        return false;
    }

    @Override
    public boolean parse(String query) {
        this.parse(this.getTokenList(query));
        return true;
    }

    @Override
    public int getChildNum() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public IRQuery getChild(int index) {
        if (index >= this.getChildNum() || index < 0) {
            return null;
        }
        return (IRQuery)this.children.get(index);
    }

    @Override
    public double getSelectivity() {
        return 0.0;
    }

    @Override
    public Operator getOperator() {
        return this.optr;
    }

    @Override
    public String toString() {
        if (this.getChildNum() == 0) {
            return null;
        }
        if (this.getChildNum() == 1) {
            return this.getChild(0).toString();
        }
        StringBuffer buf = new StringBuffer();
        if (this.optr.toString().equalsIgnoreCase("OR")) {
            buf.append('(');
        }
        for (int i = 0; i < this.getChildNum(); ++i) {
            buf.append(this.getChild(i).toString());
            if (i >= this.getChildNum() - 1) continue;
            buf.append(' ');
            buf.append(this.getOperator().toString());
            buf.append(' ');
        }
        if (this.optr.toString().equalsIgnoreCase("OR")) {
            buf.append(')');
        }
        return buf.toString();
    }

    protected String[] getTokenList(String query) {
        boolean lastSpace = false;
        StringBuffer sb = new StringBuffer(query.length());
        for (int i = 0; i < query.length(); ++i) {
            if ("()=,".indexOf(query.charAt(i)) >= 0) {
                if (!lastSpace) {
                    sb.append(' ');
                }
                sb.append(query.charAt(i));
                sb.append(' ');
                lastSpace = true;
                continue;
            }
            if (query.charAt(i) != ' ') {
                sb.append(query.charAt(i));
                lastSpace = false;
                continue;
            }
            if (lastSpace) continue;
            sb.append(' ');
            lastSpace = true;
        }
        query = sb.toString().trim();
        String[] arrToken = query.split(" ");
        return arrToken;
    }

    protected abstract void parse(String[] var1);
}

