/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.kngbase;

import dragon.ir.index.IndexReader;
import dragon.matrix.DoubleFlatSparseMatrix;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.DoubleSuperSparseMatrix;
import dragon.nlp.Token;
import dragon.util.MathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class DocRepresentation {
    private IndexReader indexReader;
    private int[] termMap;
    private boolean showMessage;

    public DocRepresentation(IndexReader indexReader) {
        this.indexReader = indexReader;
        this.showMessage = true;
    }

    public DocRepresentation(IndexReader indexReader, int[] termMap) {
        this.indexReader = indexReader;
        this.termMap = termMap;
        this.showMessage = true;
    }

    public void setMessageOption(boolean showMessage) {
        this.showMessage = showMessage;
    }

    public DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold, String matrixPath, String matrixKey) {
        return this.genModelMatrix(signatureIndexReader, null, transMatrix, transCoefficient, bkgCoefficient, isPhraseSignature, probThreshold, matrixPath, matrixKey);
    }

    public DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, int[] signatureMap, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold, String matrixPath, String matrixKey) {
        String indexDir = matrixPath;
        File file = new File(indexDir + "/" + matrixKey + ".index");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(indexDir + "/" + matrixKey + ".matrix")).exists()) {
            file.delete();
        }
        DoubleSuperSparseMatrix matrix = new DoubleSuperSparseMatrix(indexDir + "/" + matrixKey + ".index", indexDir + "/" + matrixKey + ".matrix", false, false);
        return this.genModelMatrix(signatureIndexReader, signatureMap, transMatrix, transCoefficient, bkgCoefficient, isPhraseSignature, probThreshold, matrix);
    }

    public DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold) {
        return this.genModelMatrix(signatureIndexReader, null, transMatrix, transCoefficient, bkgCoefficient, isPhraseSignature, probThreshold);
    }

    public DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, int[] signatureMap, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold) {
        DoubleFlatSparseMatrix matrix = new DoubleFlatSparseMatrix(false, false);
        return this.genModelMatrix(signatureIndexReader, signatureMap, transMatrix, transCoefficient, bkgCoefficient, isPhraseSignature, probThreshold, matrix);
    }

    private DoubleSparseMatrix genModelMatrix(IndexReader signatureIndexReader, int[] signatureMap, DoubleSparseMatrix transMatrix, double transCoefficient, double bkgCoefficient, boolean isPhraseSignature, double probThreshold, DoubleSparseMatrix matrix) {
        int i;
        int docNum = this.indexReader.getCollection().getDocNum();
        int termNum = this.termMap == null ? this.indexReader.getCollection().getTermNum() : Math.max(transMatrix.columns(), MathUtil.max(this.termMap) + 1);
        double[] arrBkgModel = new double[this.indexReader.getCollection().getTermNum()];
        double[] arrTransModel = new double[termNum];
        double weightSum = this.indexReader.getCollection().getTermCount();
        for (i = 0; i < arrBkgModel.length; ++i) {
            arrBkgModel[i] = (double)this.indexReader.getIRTerm(i).getFrequency() / weightSum * (1.0 - transCoefficient) * bkgCoefficient;
        }
        ArrayList<Token> termList = new ArrayList<Token>();
        int[] indexList = null;
        int[] freqList = null;
        for (i = 0; i < docNum; ++i) {
            Token curToken;
            double rate;
            int curSignatureIndex;
            int j;
            int signatureNum;
            if (i > 0 && i % 2000 == 0) {
                matrix.flush();
                if (this.showMessage) {
                    System.out.println(new Date() + " processing doc #" + i);
                }
            }
            if (this.indexReader.getDoc(i).getTermNum() <= 0) continue;
            if (i >= signatureIndexReader.getCollection().getDocNum()) {
                signatureNum = 0;
            } else {
                for (j = 0; j < termNum; ++j) {
                    arrTransModel[j] = 0.0;
                }
                if (isPhraseSignature) {
                    signatureNum = signatureIndexReader.getDoc(i).getTermNum();
                    indexList = signatureIndexReader.getTermIndexList(i);
                    freqList = signatureIndexReader.getTermFrequencyList(i);
                } else {
                    signatureNum = signatureIndexReader.getDoc(i).getRelationNum();
                    indexList = signatureIndexReader.getRelationIndexList(i);
                    freqList = signatureIndexReader.getRelationFrequencyList(i);
                }
            }
            int usedSignature = 0;
            weightSum = 0.0;
            for (j = 0; j < signatureNum && (curSignatureIndex = signatureMap == null ? indexList[j] : signatureMap[indexList[j]]) < transMatrix.rows(); ++j) {
                int[] cols = transMatrix.getNonZeroColumnsInRow(curSignatureIndex);
                double[] scores = transMatrix.getNonZeroDoubleScoresInRow(curSignatureIndex);
                if (cols.length > 0) {
                    ++usedSignature;
                }
                rate = freqList[j];
                weightSum += (double)freqList[j];
                for (int k = 0; k < cols.length; ++k) {
                    int n = cols[k];
                    arrTransModel[n] = arrTransModel[n] + scores[k] * rate;
                }
            }
            if (usedSignature > 0) {
                rate = transCoefficient / (double)usedSignature / weightSum;
                for (j = 0; j < termNum; ++j) {
                    if (!(arrTransModel[j] > 0.0)) continue;
                    arrTransModel[j] = arrTransModel[j] * rate;
                }
            }
            indexList = this.indexReader.getTermIndexList(i);
            freqList = this.indexReader.getTermFrequencyList(i);
            weightSum = this.indexReader.getDoc(i).getTermCount();
            rate = (1.0 - transCoefficient) * (1.0 - bkgCoefficient) / weightSum;
            for (j = 0; j < indexList.length; ++j) {
                int n = this.map(indexList[j]);
                arrTransModel[n] = arrTransModel[n] + (double)freqList[j] * rate;
            }
            for (j = 0; j < arrBkgModel.length; ++j) {
                int n = this.map(j);
                arrTransModel[n] = arrTransModel[n] + arrBkgModel[j];
            }
            if (usedSignature == 0) {
                rate = 1.0 / (1.0 - transCoefficient);
                for (j = 0; j < termNum; ++j) {
                    arrTransModel[j] = arrTransModel[j] * rate;
                }
            }
            termList.clear();
            weightSum = 0.0;
            for (j = 0; j < termNum; ++j) {
                if (!(arrTransModel[j] >= probThreshold)) continue;
                curToken = new Token(null);
                curToken.setIndex(j);
                curToken.setWeight(arrTransModel[j]);
                termList.add(curToken);
                weightSum += arrTransModel[j];
            }
            for (j = 0; j < termList.size(); ++j) {
                curToken = (Token)termList.get(j);
                matrix.add(i, curToken.getIndex(), curToken.getWeight() / weightSum);
            }
        }
        matrix.finalizeData();
        return matrix;
    }

    public DoubleSparseMatrix genTFIDFMatrix(String matrixPath, String matrixKey) {
        String indexFolder = matrixPath;
        File file = new File(indexFolder + "/" + matrixKey + ".index");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(indexFolder + "/" + matrixKey + ".matrix")).exists()) {
            file.delete();
        }
        DoubleSuperSparseMatrix tfidfMatrix = new DoubleSuperSparseMatrix(indexFolder + "/" + matrixKey + ".index", indexFolder + "/" + matrixKey + ".matrix", false, false);
        return this.genTFIDFMatrix(tfidfMatrix);
    }

    public DoubleSparseMatrix genTFIDFMatrix() {
        DoubleFlatSparseMatrix matrix = new DoubleFlatSparseMatrix(false, false);
        return this.genTFIDFMatrix(matrix);
    }

    private DoubleSparseMatrix genTFIDFMatrix(DoubleSparseMatrix matrix) {
        int i;
        double[] arrIDF = new double[this.indexReader.getCollection().getTermNum()];
        double sum = this.indexReader.getCollection().getDocNum();
        for (i = 0; i < arrIDF.length; ++i) {
            arrIDF[i] = Math.log(sum / (double)this.indexReader.getIRTerm(i).getDocFrequency());
        }
        int docNum = this.indexReader.getCollection().getDocNum();
        for (i = 0; i < docNum; ++i) {
            if (i > 0 && i % 2000 == 0) {
                matrix.flush();
                if (this.showMessage) {
                    System.out.println(new Date() + " processing doc #" + i);
                }
            }
            int[] termIndexList = this.indexReader.getTermIndexList(i);
            int[] termFreqList = this.indexReader.getTermFrequencyList(i);
            for (int j = 0; j < termIndexList.length; ++j) {
                matrix.add(i, this.map(termIndexList[j]), (double)termFreqList[j] * arrIDF[termIndexList[j]]);
            }
        }
        matrix.finalizeData();
        return matrix;
    }

    public DoubleSparseMatrix genNormTFMatrix(String matrixPath, String matrixKey) {
        String indexFolder = matrixPath;
        File file = new File(indexFolder + "/" + matrixKey + ".index");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(indexFolder + "/" + matrixKey + ".matrix")).exists()) {
            file.delete();
        }
        DoubleSuperSparseMatrix matrix = new DoubleSuperSparseMatrix(indexFolder + "/" + matrixKey + ".index", indexFolder + "/" + matrixKey + ".matrix", false, false);
        return this.genNormTFMatrix(matrix);
    }

    public DoubleSparseMatrix genNormTFMatrix() {
        DoubleFlatSparseMatrix matrix = new DoubleFlatSparseMatrix(false, false);
        return this.genNormTFMatrix(matrix);
    }

    private DoubleSparseMatrix genNormTFMatrix(DoubleSparseMatrix matrix) {
        double docNum = this.indexReader.getCollection().getDocNum();
        int i = 0;
        while ((double)i < docNum) {
            int j;
            if (i > 0 && i % 2000 == 0) {
                matrix.flush();
                if (this.showMessage) {
                    System.out.println(new Date() + " processing doc #" + i);
                }
            }
            int[] termIndexList = this.indexReader.getTermIndexList(i);
            int[] termFreqList = this.indexReader.getTermFrequencyList(i);
            double sum = 0.0;
            for (j = 0; j < termIndexList.length; ++j) {
                sum += (double)termFreqList[j] * (double)termFreqList[j];
            }
            sum = Math.sqrt(sum);
            for (j = 0; j < termIndexList.length; ++j) {
                matrix.add(i, this.map(termIndexList[j]), (double)termFreqList[j] / sum);
            }
            ++i;
        }
        matrix.finalizeData();
        return matrix;
    }

    private int map(int oldTermIndex) {
        if (this.termMap == null) {
            return oldTermIndex;
        }
        return this.termMap[oldTermIndex];
    }
}

