/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sequence;

import dragon.ir.index.Indexer;
import dragon.ir.index.sequence.AbstractSequenceIndexReader;
import dragon.ir.index.sequence.OnlineSequenceIndexer;
import dragon.nlp.extract.ConceptExtractor;
import dragon.onlinedb.Article;
import dragon.onlinedb.CollectionReader;

public class OnlineSequenceIndexReader
extends AbstractSequenceIndexReader {
    private OnlineSequenceIndexer indexer;

    public OnlineSequenceIndexReader(ConceptExtractor ce) {
        this(ce, null);
    }

    public OnlineSequenceIndexReader(ConceptExtractor ce, CollectionReader collectionReader) {
        this(new OnlineSequenceIndexer(ce), collectionReader);
    }

    public OnlineSequenceIndexReader(OnlineSequenceIndexer indexer) {
        this(indexer, null);
    }

    public OnlineSequenceIndexReader(OnlineSequenceIndexer indexer, CollectionReader collectionReader) {
        this.collectionReader = collectionReader;
        this.indexer = indexer;
    }

    @Override
    public void initialize() {
        if (this.initialized || this.collectionReader == null) {
            return;
        }
        this.indexer.initialize();
        if (!this.index(this.indexer, this.collectionReader)) {
            System.out.println("Failed to index articles!");
            return;
        }
        this.indexer.close();
        this.collection = this.indexer.getIRCollection();
        this.docIndexList = this.indexer.getDocIndexList();
        this.docKeyList = this.indexer.getDocKeyList();
        this.termIndexList = this.indexer.getTermIndexList();
        this.termKeyList = this.indexer.getTermKeyList();
        this.doctermSeq = this.indexer.getSequenceReader();
        this.initialized = true;
    }

    public void setCollectionReader(CollectionReader collectionReader) {
        this.initialized = false;
        this.collectionReader = collectionReader;
    }

    protected boolean index(Indexer indexer, CollectionReader collectionReader) {
        try {
            Article article = collectionReader.getNextArticle();
            while (article != null) {
                if (!indexer.indexed(article.getKey())) {
                    indexer.index(article);
                }
                article = collectionReader.getNextArticle();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

