/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sequence;

import dragon.ir.index.BasicIRDocIndexList;
import dragon.ir.index.BasicIRTermIndexList;
import dragon.ir.index.FileIndex;
import dragon.ir.index.IRCollection;
import dragon.ir.index.sequence.AbstractSequenceIndexReader;
import dragon.ir.index.sequence.SequenceFileReader;
import dragon.nlp.SimpleElementList;
import dragon.onlinedb.CollectionReader;

public class BasicSequenceIndexReader
extends AbstractSequenceIndexReader {
    private FileIndex fileIndex;

    public BasicSequenceIndexReader(String directory) {
        this(directory, null);
    }

    public BasicSequenceIndexReader(String directory, CollectionReader collectionReader) {
        this.collectionReader = collectionReader;
        this.fileIndex = new FileIndex(directory, false);
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.collection = new IRCollection();
        this.collection.load(this.fileIndex.getCollectionFilename());
        this.termIndexList = new BasicIRTermIndexList(this.fileIndex.getTermIndexListFilename(), false);
        this.docIndexList = new BasicIRDocIndexList(this.fileIndex.getDocIndexListFilename(), false);
        this.termKeyList = new SimpleElementList(this.fileIndex.getTermKeyListFilename(), false);
        this.docKeyList = new SimpleElementList(this.fileIndex.getDocKeyListFilename(), false);
        this.doctermSeq = new SequenceFileReader(this.fileIndex.getDocTermSeqIndexFilename(), this.fileIndex.getDocTermSeqFilename());
        this.initialized = true;
    }
}

