/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sequence;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRDocIndexList;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IRTermIndexList;
import dragon.ir.index.IndexWriter;
import dragon.ir.index.sequence.SequenceWriter;
import dragon.nlp.SimpleElementList;
import dragon.nlp.compare.IndexComparator;
import dragon.util.SortedArray;

public abstract class AbstractSequenceIndexWriter
implements IndexWriter {
    protected static int doc_cache_size = 5000;
    protected SortedArray termCache;
    protected SimpleElementList termKeyList;
    protected SimpleElementList docKeyList;
    protected IRTermIndexList termIndexList;
    protected IRDocIndexList docIndexList;
    protected SequenceWriter doctermMatrix;
    protected IRCollection collection;
    protected boolean initialized;

    public boolean indexed(String docKey) {
        return this.docKeyList.contains(docKey);
    }

    @Override
    public int size() {
        return this.docIndexList.size();
    }

    @Override
    public void flush() {
        this.collection.setDocNum(this.docIndexList.size());
        this.collection.setTermNum(this.termIndexList.size());
    }

    @Override
    public synchronized boolean write(IRDoc curDoc, IRTerm[] arrTerms, IRRelation[] arrRelations) {
        return false;
    }

    @Override
    public synchronized boolean write(IRDoc curDoc, IRTerm[] arrTerm) {
        try {
            int i;
            int docIndex = this.docKeyList.add(curDoc.getKey());
            if (docIndex != this.docKeyList.size() - 1) {
                System.out.println("#" + curDoc.getKey() + " is already indexed");
                return false;
            }
            curDoc.setIndex(docIndex);
            this.processIRTerms(arrTerm);
            int[] arrSeq = new int[arrTerm.length];
            SortedArray termList = new SortedArray(new IndexComparator());
            for (i = 0; i < arrTerm.length; ++i) {
                arrTerm[i].setDocFrequency(1);
                arrSeq[i] = arrTerm[i].getIndex();
                if (termList.add(arrTerm[i])) continue;
                ((IRTerm)termList.get(termList.insertedPos())).addFrequency(1);
            }
            curDoc.setTermCount(arrTerm.length);
            curDoc.setTermNum(termList.size());
            this.docIndexList.add(curDoc);
            for (i = 0; i < termList.size(); ++i) {
                this.termIndexList.add((IRTerm)termList.get(i));
            }
            this.doctermMatrix.addSequence(curDoc.getIndex(), arrSeq);
            this.collection.addTermCount(curDoc.getTermCount());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void processIRTerms(IRTerm[] arrTerm) {
        this.termCache.clear();
        for (int i = 0; i < arrTerm.length; ++i) {
            IRTerm cur = arrTerm[i];
            if (this.termCache.add(cur)) {
                cur.setIndex(this.termKeyList.add(cur.getKey()));
                continue;
            }
            cur.setIndex(((IRTerm)this.termCache.get(this.termCache.insertedPos())).getIndex());
        }
    }
}

