/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sequence;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRDocIndexList;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IRTermIndexList;
import dragon.ir.index.sequence.SequenceIndexReader;
import dragon.ir.index.sequence.SequenceReader;
import dragon.nlp.SimpleElementList;
import dragon.onlinedb.Article;
import dragon.onlinedb.CollectionReader;

public abstract class AbstractSequenceIndexReader
implements SequenceIndexReader {
    protected CollectionReader collectionReader;
    protected SimpleElementList termKeyList;
    protected SimpleElementList docKeyList;
    protected IRTermIndexList termIndexList;
    protected IRDocIndexList docIndexList;
    protected SequenceReader doctermSeq;
    protected IRCollection collection;
    protected boolean initialized;

    @Override
    public void close() {
        this.termIndexList.close();
        this.docIndexList.close();
        this.doctermSeq.close();
        this.initialized = false;
    }

    @Override
    public boolean isRelationSupported() {
        return false;
    }

    @Override
    public IRCollection getCollection() {
        return this.collection;
    }

    @Override
    public IRDoc getDoc(int index) {
        return this.docIndexList.get(index).copy();
    }

    @Override
    public String getDocKey(int index) {
        return this.docKeyList.search(index);
    }

    @Override
    public IRDoc getDoc(String key) {
        int index = this.docKeyList.search(key);
        if (index >= 0) {
            IRDoc cur = this.getDoc(index);
            cur.setKey(key);
            return cur;
        }
        return null;
    }

    @Override
    public Article getOriginalDoc(String key) {
        if (this.collectionReader == null) {
            System.out.println("Collection Reader is not set yet!");
            return null;
        }
        return this.collectionReader.getArticleByKey(key);
    }

    @Override
    public Article getOriginalDoc(int index) {
        return this.getOriginalDoc(this.getDocKey(index));
    }

    @Override
    public IRTerm[] getTermList(int docIndex) {
        int len = this.doctermSeq.getSequenceLength(docIndex);
        if (len == 0) {
            return null;
        }
        int[] arrIndex = this.getTermIndexList(docIndex);
        IRTerm[] arrTerm = new IRTerm[len];
        for (int i = 0; i < len; ++i) {
            arrTerm[i] = new IRTerm(arrIndex[i], 1);
        }
        return arrTerm;
    }

    @Override
    public int[] getTermIndexList(int docIndex) {
        return this.doctermSeq.getSequence(docIndex);
    }

    @Override
    public int[] getTermFrequencyList(int docIndex) {
        int len = this.doctermSeq.getSequenceLength(docIndex);
        if (len == 0) {
            return null;
        }
        int[] arrFreq = new int[len];
        for (int i = 0; i < len; ++i) {
            arrFreq[i] = 1;
        }
        return arrFreq;
    }

    @Override
    public IRTerm getIRTerm(int index) {
        return this.termIndexList.get(index);
    }

    @Override
    public String getTermKey(int index) {
        return this.termKeyList.search(index);
    }

    @Override
    public IRTerm getIRTerm(String key) {
        int pos = this.termKeyList.search(key);
        if (pos >= 0) {
            IRTerm cur = this.termIndexList.get(pos);
            cur.setKey(key);
            return cur;
        }
        return null;
    }

    @Override
    public IRTerm getIRTerm(int termIndex, int docIndex) {
        return null;
    }

    @Override
    public IRDoc[] getTermDocList(int termIndex) {
        return null;
    }

    @Override
    public int[] getTermDocFrequencyList(int termIndex) {
        return null;
    }

    @Override
    public int[] getTermDocIndexList(int termIndex) {
        return null;
    }

    @Override
    public IRRelation[] getRelationList(int docIndex) {
        return null;
    }

    @Override
    public int[] getRelationFrequencyList(int docIndex) {
        return null;
    }

    @Override
    public int[] getRelationIndexList(int docIndex) {
        return null;
    }

    @Override
    public IRRelation getIRRelation(int index) {
        return null;
    }

    @Override
    public IRRelation getIRRelation(int relationIndex, int docIndex) {
        return null;
    }

    @Override
    public IRDoc[] getRelationDocList(int relationIndex) {
        return null;
    }

    @Override
    public int[] getRelationDocFrequencyList(int relationIndex) {
        return null;
    }

    @Override
    public int[] getRelationDocIndexList(int relationIndex) {
        return null;
    }
}

