/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sentence;

import dragon.ir.index.AbstractIndexReader;
import dragon.ir.index.Indexer;
import dragon.ir.index.sentence.OnlineSentenceBase;
import dragon.ir.index.sentence.OnlineSentenceIndexer;
import dragon.matrix.IntSparseMatrix;
import dragon.onlinedb.Article;
import dragon.onlinedb.BasicArticle;
import dragon.onlinedb.CollectionReader;

public class OnlineSentenceIndexReader
extends AbstractIndexReader {
    protected OnlineSentenceIndexer indexer;
    private OnlineSentenceBase sentBase;

    public OnlineSentenceIndexReader(OnlineSentenceIndexer indexer) {
        this(indexer, null);
    }

    public OnlineSentenceIndexReader(OnlineSentenceIndexer indexer, CollectionReader collectionReader) {
        super(indexer.isRelationSupported(), collectionReader);
        this.indexer = indexer;
    }

    @Override
    public void initialize() {
        if (this.initialized || this.collectionReader == null) {
            return;
        }
        this.indexer.initialize();
        if (!this.index(this.indexer, this.collectionReader)) {
            System.out.println("Failed to index articles!");
            return;
        }
        this.indexer.close();
        this.collection = this.indexer.getIRCollection();
        this.sentBase = this.indexer.getSentenceBase();
        this.docIndexList = this.indexer.getDocIndexList();
        this.docKeyList = this.indexer.getDocKeyList();
        this.termIndexList = this.indexer.getTermIndexList();
        this.termKeyList = this.indexer.getTermKeyList();
        this.doctermMatrix = this.indexer.getDocTermMatrix();
        this.doctermMatrix.finalizeData();
        this.termdocMatrix = (IntSparseMatrix)this.doctermMatrix.transpose();
        if (this.relationSupported) {
            this.relationIndexList = this.indexer.getRelationIndexList();
            this.docrelationMatrix = this.indexer.getDocRelationMatrix();
            this.docrelationMatrix.finalizeData();
            this.relationdocMatrix = (IntSparseMatrix)this.docrelationMatrix.transpose();
        }
        this.initialized = true;
    }

    public void setCollectionReader(CollectionReader collectionReader) {
        this.initialized = false;
        this.collectionReader = collectionReader;
    }

    @Override
    public void close() {
        this.indexer.close();
        super.close();
    }

    @Override
    public Article getOriginalDoc(String key) {
        BasicArticle article = new BasicArticle();
        article.setTitle(this.sentBase.get(key));
        if (article.getTitle() == null) {
            return null;
        }
        article.setKey(key);
        return article;
    }

    protected boolean index(Indexer indexer, CollectionReader collectionReader) {
        try {
            Article article = collectionReader.getNextArticle();
            while (article != null) {
                if (!indexer.indexed(article.getKey())) {
                    indexer.index(article);
                }
                article = collectionReader.getNextArticle();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

