/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sentence;

import dragon.ir.index.sentence.AbstractSentenceIndexer;
import dragon.ir.index.sentence.BasicSentenceWriteController;
import dragon.nlp.Sentence;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.TripleExtractor;
import java.util.ArrayList;

public class BasicSentenceIndexer
extends AbstractSentenceIndexer {
    private BasicSentenceWriteController writer;
    private ConceptExtractor cptExtractor;
    private TripleExtractor tripleExtractor;

    public BasicSentenceIndexer(ConceptExtractor extractor, boolean useConcept, String indexFolder) {
        super(extractor.getDocumentParser());
        this.cptExtractor = extractor;
        this.writer = new BasicSentenceWriteController(indexFolder, false, useConcept);
    }

    public BasicSentenceIndexer(TripleExtractor extractor, boolean useConcept, String indexFolder) {
        super(extractor.getConceptExtractor().getDocumentParser());
        this.tripleExtractor = extractor;
        this.cptExtractor = extractor.getConceptExtractor();
        this.writer = new BasicSentenceWriteController(indexFolder, true, useConcept);
    }

    public boolean indexedSentence(String sentKey) {
        return this.writer.indexed(sentKey);
    }

    @Override
    public boolean index(Sentence sent, String sentKey) {
        try {
            if (sent == null || sent.getFirstWord() == null || this.writer.indexed(sentKey)) {
                return false;
            }
            this.writer.addRawSentence(sent);
            ArrayList cptList = this.cptExtractor.extractFromSentence(sent);
            if (this.writer.isRelationSupported()) {
                ArrayList tripleList = this.tripleExtractor.extractFromSentence(sent);
                this.writer.write(cptList, tripleList);
            } else {
                this.writer.write(cptList);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.writer.initialize();
        this.initialized = true;
    }

    @Override
    public void close() {
        this.writer.close();
        super.close();
    }
}

