/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.BasicIRRelationIndexList;
import dragon.ir.index.BasicIRTermIndexList;
import dragon.ir.index.FileIndex;
import dragon.ir.index.IRCollection;
import dragon.matrix.IntFlatSparseMatrix;
import dragon.matrix.IntGiantSparseMatrix;
import dragon.matrix.IntSparseMatrix;
import dragon.util.ByteArrayConvert;
import dragon.util.ByteArrayWriter;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Date;

public class TransposeIRMatrix {
    public static void main(String[] args) {
        TransposeIRMatrix transpose = new TransposeIRMatrix();
        StringBuffer directory = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            directory.append(args[i]);
            directory.append(' ');
        }
        transpose.genTermDocMatrix(directory.toString().trim());
    }

    public void genTermDocMatrix(String directory) {
        try {
            FileIndex indexer = new FileIndex(directory, false);
            File oldMatrix = new File(indexer.getTermDocFilename() + ".tmp");
            File newMatrix = new File(indexer.getTermDocFilename());
            if (newMatrix.exists() && !newMatrix.renameTo(oldMatrix)) {
                return;
            }
            File oldIndex = new File(indexer.getTermDocIndexFilename() + ".tmp");
            File newIndex = new File(indexer.getTermDocIndexFilename());
            if (newIndex.exists() && !newIndex.renameTo(oldIndex)) {
                return;
            }
            int oldDocNum = 0;
            long[] arrOffset = this.initTermDocMatrix(indexer);
            if (oldMatrix.exists()) {
                oldDocNum = this.mergeOldMatrix(arrOffset, newMatrix, oldMatrix);
            }
            RandomAccessFile raf = new RandomAccessFile(indexer.getTermDocFilename(), "rw");
            IntGiantSparseMatrix doctermMatrix = new IntGiantSparseMatrix(indexer.getDocTermIndexFilename(), indexer.getDocTermFilename());
            this.genTransposeMatrix(raf, oldDocNum, arrOffset, doctermMatrix);
            if (oldMatrix.exists()) {
                oldMatrix.delete();
            }
            if (oldIndex.exists()) {
                oldIndex.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void genRelationDocMatrix(String directory) {
        try {
            FileIndex indexer = new FileIndex(directory, false);
            File oldMatrix = new File(indexer.getRelationDocFilename() + ".tmp");
            File newMatrix = new File(indexer.getRelationDocFilename());
            if (newMatrix.exists() && !newMatrix.renameTo(oldMatrix)) {
                return;
            }
            File oldIndex = new File(indexer.getRelationDocIndexFilename() + ".tmp");
            File newIndex = new File(indexer.getRelationDocIndexFilename());
            if (newIndex.exists() && !newIndex.renameTo(oldIndex)) {
                return;
            }
            int oldDocNum = 0;
            long[] arrOffset = this.initRelationDocMatrix(indexer);
            if (oldMatrix.exists()) {
                oldDocNum = this.mergeOldMatrix(arrOffset, newMatrix, oldMatrix);
            }
            RandomAccessFile raf = new RandomAccessFile(indexer.getRelationDocFilename(), "rw");
            IntGiantSparseMatrix docrelationMatrix = new IntGiantSparseMatrix(indexer.getDocRelationIndexFilename(), indexer.getDocRelationFilename());
            this.genTransposeMatrix(raf, oldDocNum, arrOffset, docrelationMatrix);
            if (oldMatrix.exists()) {
                oldMatrix.delete();
            }
            if (oldIndex.exists()) {
                oldIndex.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long[] initTermDocMatrix(FileIndex indexer) {
        try {
            byte[] buf = new byte[8];
            int i = 0;
            ByteArrayConvert.toByte(i, buf, 0);
            ByteArrayConvert.toByte(i, buf, 4);
            IRCollection collection = new IRCollection();
            BasicIRTermIndexList indexList = new BasicIRTermIndexList(indexer.getTermIndexListFilename(), false);
            collection.load(indexer.getCollectionFilename());
            long[] arrOffset = new long[collection.getTermNum()];
            System.out.println(new Date().toString() + " initializing term doc matrix...");
            int totalCell = this.readCellNum(indexer.getDocTermFilename());
            FastBinaryWriter fbwMatrix = new FastBinaryWriter(indexer.getTermDocFilename());
            FastBinaryWriter fbwIndex = new FastBinaryWriter(indexer.getTermDocIndexFilename());
            fbwMatrix.writeInt(collection.getTermNum());
            fbwMatrix.writeInt(collection.getDocNum());
            fbwMatrix.writeInt(totalCell);
            fbwIndex.writeInt(collection.getTermNum());
            fbwIndex.writeInt(collection.getDocNum());
            fbwIndex.writeInt(totalCell);
            for (i = 0; i < indexList.size(); ++i) {
                int len = indexList.get(i).getDocFrequency();
                fbwIndex.writeInt(i);
                fbwIndex.writeLong(fbwMatrix.getFilePointer());
                fbwIndex.writeInt(len);
                fbwIndex.flush();
                fbwMatrix.writeInt(i);
                fbwMatrix.writeInt(len);
                arrOffset[i] = fbwMatrix.getFilePointer();
                for (int j = 0; j < len; ++j) {
                    fbwMatrix.write(buf);
                }
            }
            fbwIndex.close();
            fbwMatrix.close();
            return arrOffset;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private long[] initRelationDocMatrix(FileIndex indexer) {
        try {
            byte[] buf = new byte[8];
            int i = 0;
            ByteArrayConvert.toByte(i, buf, 0);
            ByteArrayConvert.toByte(i, buf, 4);
            IRCollection collection = new IRCollection();
            BasicIRRelationIndexList indexList = new BasicIRRelationIndexList(indexer.getRelationIndexListFilename(), false);
            collection.load(indexer.getCollectionFilename());
            long[] arrOffset = new long[collection.getRelationNum()];
            System.out.println(new Date().toString() + " initializing relation doc matrix...");
            int totalCell = this.readCellNum(indexer.getDocRelationFilename());
            FastBinaryWriter fbwMatrix = new FastBinaryWriter(indexer.getRelationDocFilename());
            FastBinaryWriter fbwIndex = new FastBinaryWriter(indexer.getRelationDocIndexFilename());
            fbwMatrix.writeInt(collection.getRelationNum());
            fbwMatrix.writeInt(collection.getDocNum());
            fbwMatrix.writeInt(totalCell);
            fbwIndex.writeInt(collection.getRelationNum());
            fbwIndex.writeInt(collection.getDocNum());
            fbwIndex.writeInt(totalCell);
            for (i = 0; i < indexList.size(); ++i) {
                int len = indexList.get(i).getDocFrequency();
                fbwIndex.writeInt(i);
                fbwIndex.writeLong(fbwMatrix.getFilePointer());
                fbwIndex.writeInt(len);
                fbwIndex.flush();
                fbwMatrix.writeInt(i);
                fbwMatrix.writeInt(len);
                arrOffset[i] = fbwMatrix.getFilePointer();
                for (int j = 0; j < len; ++j) {
                    fbwMatrix.write(buf);
                }
            }
            fbwIndex.close();
            fbwMatrix.close();
            return arrOffset;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void genTransposeMatrix(RandomAccessFile newMatrix, int startingRow, long[] arrOffset, IntSparseMatrix oldMatrix) {
        try {
            int i;
            int doc_cache = 40000;
            int count = 0;
            IntFlatSparseMatrix cacheMatrix = new IntFlatSparseMatrix(false, true);
            for (i = startingRow; i < oldMatrix.rows(); ++i) {
                ++count;
                int[] arrColumn = oldMatrix.getNonZeroColumnsInRow(i);
                int[] arrFreq = oldMatrix.getNonZeroIntScoresInRow(i);
                for (int j = 0; j < arrColumn.length; ++j) {
                    cacheMatrix.add(arrColumn[j], i, arrFreq[j]);
                }
                if (count < doc_cache) continue;
                System.out.println(new Date().toString() + " processing row #" + i);
                count = 0;
                cacheMatrix.finalizeData();
                this.add(newMatrix, arrOffset, cacheMatrix);
                cacheMatrix.close();
            }
            if (count > 0) {
                System.out.println(new Date().toString() + " processing row #" + i);
                count = 0;
                cacheMatrix.finalizeData();
                this.add(newMatrix, arrOffset, cacheMatrix);
                cacheMatrix.close();
            }
            newMatrix.close();
            oldMatrix.close();
            System.out.println("Done!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void add(RandomAccessFile newMatrix, long[] arrOffset, IntFlatSparseMatrix cacheMatrix) {
        try {
            System.out.println(new Date().toString() + " dumping to disk");
            ByteArrayWriter baw = new ByteArrayWriter();
            int start = cacheMatrix.getBaseRow();
            int end = cacheMatrix.rows();
            for (int i = start; i < end; ++i) {
                int len = cacheMatrix.getNonZeroNumInRow(i);
                if (len == 0) continue;
                newMatrix.seek(arrOffset[i]);
                for (int j = 0; j < len; ++j) {
                    baw.writeInt(cacheMatrix.getNonZeroColumnInRow(i, j));
                    baw.writeInt(cacheMatrix.getNonZeroIntScoreInRow(i, j));
                }
                newMatrix.write(baw.toByteArray());
                baw.reset();
                int n = i;
                arrOffset[n] = arrOffset[n] + (long)(8 * len);
            }
            baw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int readCellNum(String filename) {
        try {
            FastBinaryReader reader = new FastBinaryReader(filename);
            reader.skip(8L);
            int cellNum = reader.readInt();
            reader.close();
            return cellNum;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int mergeOldMatrix(long[] arrOffset, File newMatrix, File oldMatrix) {
        try {
            System.out.println(new Date().toString() + " merging old term doc matrix...");
            FastBinaryReader fbr = new FastBinaryReader(oldMatrix);
            RandomAccessFile raf = new RandomAccessFile(newMatrix, "rw");
            int rows = fbr.readInt();
            int cols = fbr.readInt();
            fbr.skip(4L);
            for (int i = 0; i < rows; ++i) {
                fbr.skip(4L);
                int len = fbr.readInt();
                if (len <= 0) continue;
                raf.seek(arrOffset[i]);
                this.move(fbr, raf, len * 8);
                int n = i;
                arrOffset[n] = arrOffset[n] + (long)(len * 8);
            }
            fbr.close();
            raf.close();
            return cols;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void move(FastBinaryReader src, RandomAccessFile dest, long length) {
        try {
            byte[] buf = new byte[(int)(10240L < length ? 10240L : length)];
            while (length > 0L) {
                int count = (int)(length > (long)buf.length ? (long)buf.length : length);
                if ((count = src.read(buf, 0, count)) > 0) {
                    dest.write(buf, 0, count);
                    length -= (long)count;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

