/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.AbstractIndexer;
import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDocIndexList;
import dragon.ir.index.IRRelationIndexList;
import dragon.ir.index.IRSection;
import dragon.ir.index.IRTermIndexList;
import dragon.ir.index.OnlineIndexWriteController;
import dragon.matrix.IntSparseMatrix;
import dragon.nlp.SimpleElementList;
import dragon.nlp.SimplePairList;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.TripleExtractor;
import dragon.onlinedb.Article;
import java.util.ArrayList;

public class OnlineIndexer
extends AbstractIndexer {
    private TripleExtractor te;
    private ConceptExtractor ce;
    private OnlineIndexWriteController writer;
    private int minArticleSize;
    private boolean useTitle;
    private boolean useAbstract;
    private boolean useBody;
    private boolean useMeta;

    public OnlineIndexer(TripleExtractor te, boolean useConcept) {
        super(true);
        this.te = te;
        this.minArticleSize = 3;
        this.useTitle = true;
        this.useAbstract = true;
        this.useBody = true;
        this.useMeta = true;
        this.addSection(new IRSection(0));
        this.writer = new OnlineIndexWriteController(this.relationSupported, useConcept);
    }

    public OnlineIndexer(ConceptExtractor ce, boolean useConcept) {
        super(false);
        this.ce = ce;
        this.minArticleSize = 3;
        this.useTitle = true;
        this.useAbstract = true;
        this.useBody = true;
        this.useMeta = true;
        this.addSection(new IRSection(0));
        this.writer = new OnlineIndexWriteController(this.relationSupported, useConcept);
    }

    @Override
    public void close() {
        this.initialized = false;
        this.writer.close();
    }

    public boolean isRelationSupported() {
        return this.relationSupported;
    }

    @Override
    public boolean indexed(String docKey) {
        return this.writer.indexed(docKey);
    }

    public void setMinArticleSize(int minSize) {
        this.minArticleSize = minSize;
    }

    public boolean screenArticleContent(boolean useTitle, boolean useAbstract, boolean useBody, boolean useMeta) {
        if (this.initialized) {
            return false;
        }
        this.useTitle = useTitle;
        this.useAbstract = useAbstract;
        this.useBody = useBody;
        this.useMeta = useMeta;
        return true;
    }

    public IRTermIndexList getTermIndexList() {
        return this.writer.getTermIndexList();
    }

    public IRRelationIndexList getRelationIndexList() {
        return this.writer.getRelationIndexList();
    }

    public IRDocIndexList getDocIndexList() {
        return this.writer.getDocIndexList();
    }

    public SimpleElementList getDocKeyList() {
        return this.writer.getDocKeyList();
    }

    public SimpleElementList getTermKeyList() {
        return this.writer.getTermKeyList();
    }

    public SimplePairList getRelationKeyList() {
        return this.writer.getRelationKeyList();
    }

    public IntSparseMatrix getDocTermMatrix() {
        return this.writer.getDocTermMatrix();
    }

    public IntSparseMatrix getDocRelationMatrix() {
        return this.writer.getDocRelationMatrix();
    }

    public IRCollection getIRCollection() {
        return this.writer.getIRCollection();
    }

    @Override
    protected void initDocIndexing() {
        if (this.te != null) {
            this.te.initDocExtraction();
        }
        if (this.ce != null) {
            this.ce.initDocExtraction();
        }
    }

    @Override
    protected boolean extract(String content, ArrayList conceptList, ArrayList relationList) {
        try {
            if (content == null || content.length() < this.minArticleSize) {
                return true;
            }
            boolean ret = this.te.extractFromDoc(content);
            if (ret) {
                if (this.te.getConceptList() != null) {
                    conceptList.addAll(this.te.getConceptList());
                }
                if (this.te.getTripleList() != null) {
                    relationList.addAll(this.te.getTripleList());
                }
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean extract(String content, ArrayList conceptList) {
        try {
            if (content == null || content.length() < this.minArticleSize) {
                return true;
            }
            if (this.ce.extractFromDoc(content) != null) {
                conceptList.addAll(this.ce.getConceptList());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected String getRemainingSections(Article paper) {
        String section;
        StringBuffer sb = new StringBuffer();
        if (this.useTitle && (section = paper.getTitle()) != null && section.length() >= this.minArticleSize) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(section);
        }
        if (this.useAbstract && (section = paper.getAbstract()) != null && section.length() >= this.minArticleSize) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(section);
        }
        if (this.useBody && (section = paper.getBody()) != null && section.length() >= this.minArticleSize) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(section);
        }
        if (this.useMeta && (section = paper.getMeta()) != null && section.length() >= this.minArticleSize) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(section);
        }
        return sb.toString();
    }

    @Override
    protected void write(int sectionID, ArrayList conceptList) {
        this.writer.write(conceptList);
    }

    @Override
    protected void write(int sectionID, ArrayList conceptList, ArrayList relationList) {
        this.writer.write(conceptList, relationList);
    }

    @Override
    protected void initSectionWrite(IRSection section) {
    }

    @Override
    protected void initIndex() {
        this.writer.initialize();
    }

    @Override
    protected boolean setDoc(String docKey) {
        return this.writer.setDoc(docKey);
    }
}

