/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.AbstractIndexWriter;
import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDocIndexList;
import dragon.ir.index.IRRelationIndexList;
import dragon.ir.index.IRTermIndexList;
import dragon.ir.index.OnlineIRDocIndexList;
import dragon.ir.index.OnlineIRRelationIndexList;
import dragon.ir.index.OnlineIRTermIndexList;
import dragon.matrix.IntFlatSparseMatrix;
import dragon.matrix.IntSparseMatrix;

public class OnlineIndexWriter
extends AbstractIndexWriter {
    public OnlineIndexWriter(boolean relationSupported) {
        super(relationSupported);
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.collection = new IRCollection();
        this.docIndexList = new OnlineIRDocIndexList();
        this.termIndexList = new OnlineIRTermIndexList();
        this.doctermMatrix = new IntFlatSparseMatrix(false, false);
        if (this.relationSupported) {
            this.relationIndexList = new OnlineIRRelationIndexList();
            this.docrelationMatrix = new IntFlatSparseMatrix(false, false);
        }
        this.initialized = true;
    }

    @Override
    public void close() {
        this.flush();
        this.doctermMatrix.finalizeData();
        if (this.relationSupported) {
            this.docrelationMatrix.finalizeData();
        }
        this.initialized = false;
    }

    @Override
    public void clean() {
        this.termIndexList.close();
        this.docIndexList.close();
        this.doctermMatrix.close();
        if (this.relationSupported) {
            this.relationIndexList.close();
            this.docrelationMatrix.close();
        }
    }

    @Override
    public void flush() {
        this.collection.setDocNum(this.docIndexList.size());
        this.collection.setTermNum(this.termIndexList.size());
        if (this.relationSupported) {
            this.collection.setRelationNum(this.relationIndexList.size());
        }
    }

    public IRTermIndexList getTermIndexList() {
        return this.termIndexList;
    }

    public IRRelationIndexList getRelationIndexList() {
        return this.relationIndexList;
    }

    public IRDocIndexList getDocIndexList() {
        return this.docIndexList;
    }

    public IntSparseMatrix getDocTermMatrix() {
        return this.doctermMatrix;
    }

    public IntSparseMatrix getDocRelationMatrix() {
        return this.docrelationMatrix;
    }

    public IRCollection getIRCollection() {
        return this.collection;
    }
}

