/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRSignature;
import dragon.ir.index.IRSignatureIndexList;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IRTermIndexList;
import java.util.ArrayList;

public class OnlineIRTermIndexList
implements IRTermIndexList,
IRSignatureIndexList {
    private ArrayList indexList = new ArrayList(2000);

    @Override
    public IRSignature getIRSignature(int index) {
        return this.get(index);
    }

    @Override
    public IRTerm get(int index) {
        return index < this.indexList.size() ? (IRTerm)this.indexList.get(index) : null;
    }

    @Override
    public boolean add(IRTerm curTerm) {
        if (curTerm.getIndex() < this.indexList.size()) {
            IRTerm oldTerm = (IRTerm)this.indexList.get(curTerm.getIndex());
            oldTerm.addFrequency(curTerm.getFrequency());
            oldTerm.setDocFrequency(oldTerm.getDocFrequency() + curTerm.getDocFrequency());
        } else {
            for (int i = this.indexList.size(); i < curTerm.getIndex(); ++i) {
                this.indexList.add(new IRTerm(i, 0, 0));
            }
            curTerm = curTerm.copy();
            this.indexList.add(curTerm);
        }
        return true;
    }

    @Override
    public void close() {
        this.indexList.clear();
    }

    @Override
    public int size() {
        return this.indexList.size();
    }
}

