/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRRelation;
import dragon.ir.index.IRRelationIndexList;
import dragon.ir.index.IRSignature;
import dragon.ir.index.IRSignatureIndexList;
import java.util.ArrayList;

public class OnlineIRRelationIndexList
implements IRRelationIndexList,
IRSignatureIndexList {
    private ArrayList indexList = new ArrayList(5000);

    @Override
    public IRSignature getIRSignature(int index) {
        return this.get(index);
    }

    @Override
    public IRRelation get(int index) {
        return index < this.indexList.size() ? (IRRelation)this.indexList.get(index) : null;
    }

    @Override
    public boolean add(IRRelation curRelation) {
        if (curRelation.getIndex() < this.indexList.size()) {
            IRRelation oldRelation = (IRRelation)this.indexList.get(curRelation.getIndex());
            oldRelation.addFrequency(curRelation.getFrequency());
            oldRelation.setDocFrequency(oldRelation.getDocFrequency() + curRelation.getDocFrequency());
        } else {
            for (int i = this.indexList.size(); i < curRelation.getIndex(); ++i) {
                this.indexList.add(new IRRelation(i, 0, 0, -1, -1));
            }
            curRelation = curRelation.copy();
            this.indexList.add(curRelation);
        }
        return true;
    }

    @Override
    public int size() {
        return this.indexList.size();
    }

    @Override
    public void close() {
        this.indexList.clear();
    }
}

