/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.BasicIndexWriteController;
import dragon.ir.index.IRSection;
import dragon.matrix.DoubleGiantSparseMatrix;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.DoubleSuperSparseMatrix;
import dragon.matrix.IntGiantSparseMatrix;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.nlp.SimpleElementList;
import dragon.nlp.Token;
import dragon.util.FileUtil;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.ArrayList;

public class IndexConverter {
    public void importIndex(String indexFolder, String doctermFile) {
        try {
            String line;
            int sectionID = 0;
            ArrayList<Token> conceptList = new ArrayList<Token>(500);
            BasicIndexWriteController controller = new BasicIndexWriteController(indexFolder, false, false);
            controller.addSection(new IRSection(sectionID, "all"));
            controller.initialize();
            BufferedReader br = FileUtil.getTextReader(doctermFile);
            while ((line = br.readLine()) != null) {
                String[] arrField = line.split("\t");
                String docKey = arrField[0];
                int featureNum = Integer.parseInt(arrField[1]);
                if (!controller.setDoc(docKey)) continue;
                conceptList.clear();
                for (int i = 0; i < featureNum; ++i) {
                    Token token = new Token(arrField[2 + i * 2]);
                    token.setFrequency(Integer.parseInt(arrField[3 + i * 2]));
                    conceptList.add(token);
                }
                controller.write(sectionID, conceptList);
            }
            controller.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void importDocLinkage(String indexFolder, String doclinkFile, boolean outputTransposedMatrix) {
        try {
            String line;
            SimpleElementList docList = new SimpleElementList(indexFolder + "/dockey.list", false);
            DoubleSuperSparseMatrix matrix = new DoubleSuperSparseMatrix(indexFolder + "/doclinkage.index", indexFolder + "/doclinkage.matrix", false, false);
            DoubleSuperSparseMatrix matrixT = outputTransposedMatrix ? new DoubleSuperSparseMatrix(indexFolder + "/doclinkaget.index", indexFolder + "/doclinkaget.matrix", false, false) : null;
            BufferedReader br = FileUtil.getTextReader(doclinkFile);
            while ((line = br.readLine()) != null) {
                String[] arrField = line.split("\t");
                int src = docList.search(arrField[0]);
                int num = Integer.parseInt(arrField[1]);
                if (src < 0 || num == 0) continue;
                for (int i = 0; i < num; ++i) {
                    int dest = docList.search(arrField[2 + 2 * i]);
                    if (dest < 0) continue;
                    double weight = Double.parseDouble(arrField[3 + 2 * i]);
                    matrix.add(src, dest, weight);
                    if (matrixT == null) continue;
                    matrixT.add(dest, src, weight);
                }
            }
            docList.close();
            matrix.finalizeData(true);
            matrix.close();
            if (matrixT != null) {
                matrixT.finalizeData(true);
                matrixT.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportIndex(String indexFolder, String contentFile) {
        this.exportIndex(indexFolder, "all", contentFile);
    }

    public void exportIndex(String indexFolder, String section, String contentFile) {
        SimpleElementList docList = new SimpleElementList(indexFolder + "/dockey.list", false);
        SimpleElementList termList = new SimpleElementList(indexFolder + "/termkey.list", false);
        IntGiantSparseMatrix matrix = new IntGiantSparseMatrix(indexFolder + "/all/docterm.index", indexFolder + "/all/docterm.matrix");
        this.exportMatrix(docList, docList, matrix, contentFile);
        docList.close();
        termList.close();
        matrix.close();
    }

    public void exportDocLinkage(String indexFolder, String docRelationFile) {
        SimpleElementList docList = new SimpleElementList(indexFolder + "/dockey.list", false);
        DoubleGiantSparseMatrix matrix = new DoubleGiantSparseMatrix(indexFolder + "/doclinkage.index", indexFolder + "/doclinkage.matrix");
        this.exportMatrix(docList, docList, matrix, docRelationFile);
        docList.close();
        matrix.close();
    }

    public void exportMatrix(SimpleElementList rowList, SimpleElementList colList, DoubleSparseMatrix matrix, String outputFile) {
        this.exportMatrix(rowList, colList, matrix, false, outputFile);
    }

    public void exportMatrix(SimpleElementList rowList, SimpleElementList colList, IntSparseMatrix matrix, String outputFile) {
        this.exportMatrix(rowList, colList, matrix, true, outputFile);
    }

    public void exportMatrix(SimpleElementList rowList, SimpleElementList colList, SparseMatrix matrix, boolean exportAsInteger, String outputFile) {
        PrintWriter out = FileUtil.getPrintWriter(outputFile);
        int[] arrIntWeight = null;
        double[] arrDblWeight = null;
        for (int i = 0; i < matrix.rows(); ++i) {
            out.print(rowList.search(i));
            out.print('\t');
            int[] arrIndex = matrix.getNonZeroColumnsInRow(i);
            if (exportAsInteger) {
                arrIntWeight = matrix.getNonZeroIntScoresInRow(i);
            } else {
                arrDblWeight = matrix.getNonZeroDoubleScoresInRow(i);
            }
            int termNum = arrIndex == null ? 0 : arrIndex.length;
            out.print(termNum);
            for (int j = 0; j < termNum; ++j) {
                out.print('\t');
                out.print(colList.search(arrIndex[j]));
                out.print('\t');
                if (exportAsInteger) {
                    out.print(arrIntWeight[j]);
                    continue;
                }
                out.print(arrDblWeight[j]);
            }
            out.print('\n');
            out.flush();
        }
        out.close();
    }
}

