/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRSignature;
import dragon.nlp.compare.FrequencySortable;
import dragon.nlp.compare.IndexSortable;
import java.io.Serializable;

public class IRRelation
implements IRSignature,
IndexSortable,
FrequencySortable,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int first;
    private int second;
    private int docFrequency;
    private int frequency;
    private int index;

    public IRRelation(int firstTermIndex, int secondTermIndex, int frequency) {
        this.first = firstTermIndex;
        this.second = secondTermIndex;
        this.index = -1;
        this.frequency = frequency;
        this.docFrequency = 0;
    }

    public IRRelation(int index, int firstTermIndex, int secondTermIndex, int frequency, int docFrequency) {
        this.first = firstTermIndex;
        this.second = secondTermIndex;
        this.index = index;
        this.frequency = frequency;
        this.docFrequency = docFrequency;
    }

    public IRRelation copy() {
        return new IRRelation(this.index, this.first, this.second, this.frequency, this.docFrequency);
    }

    public int getFirstTerm() {
        return this.first;
    }

    public void setFirstTerm(int first) {
        this.first = first;
    }

    public int getSecondTerm() {
        return this.second;
    }

    public void setSecondTerm(int second) {
        this.second = second;
    }

    @Override
    public void setFrequency(int freq) {
        this.frequency = freq;
    }

    public void addFrequency(int inc) {
        this.frequency += inc;
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getDocFrequency() {
        return this.docFrequency;
    }

    public void addDocFrequency(int inc) {
        this.docFrequency += inc;
    }

    @Override
    public void setDocFrequency(int freq) {
        this.docFrequency = freq;
    }

    public int compareTo(Object obj) {
        int indexObj = ((IRRelation)obj).getFirstTerm();
        if (this.first == indexObj) {
            indexObj = ((IRRelation)obj).getSecondTerm();
            if (this.second == indexObj) {
                return 0;
            }
            if (this.second > indexObj) {
                return 1;
            }
            return -1;
        }
        if (this.first > indexObj) {
            return 1;
        }
        return -1;
    }
}

