/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.nlp.compare.IndexSortable;
import dragon.nlp.compare.WeightSortable;
import java.io.Serializable;

public class IRDoc
implements WeightSortable,
IndexSortable,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int index;
    private int category;
    private String key;
    private int termNum;
    private int termCount;
    private int relationNum;
    private int relationCount;
    private double weight;

    public IRDoc(String key) {
        this.key = key;
        this.index = -1;
        this.category = -1;
        this.termNum = 0;
        this.termCount = 0;
        this.relationNum = 0;
        this.relationCount = 0;
    }

    public IRDoc(int index) {
        this.index = index;
        this.key = null;
        this.termNum = 0;
        this.termCount = 0;
        this.relationNum = 0;
        this.relationCount = 0;
    }

    public IRDoc copy() {
        IRDoc cur = new IRDoc(this.key);
        cur.setIndex(this.index);
        cur.setTermCount(this.termCount);
        cur.setTermNum(this.termNum);
        cur.setRelationCount(this.relationCount);
        cur.setRelationNum(this.relationNum);
        cur.setWeight(this.weight);
        return cur;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public int getTermNum() {
        return this.termNum;
    }

    public void setTermNum(int termNum) {
        this.termNum = termNum;
    }

    public int getTermCount() {
        return this.termCount;
    }

    public void setTermCount(int termCount) {
        this.termCount = termCount;
    }

    public int getRelationNum() {
        return this.relationNum;
    }

    public void setRelationNum(int relationNum) {
        this.relationNum = relationNum;
    }

    public int getRelationCount() {
        return this.relationCount;
    }

    public void setRelationCount(int relationCount) {
        this.relationCount = relationCount;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public int compareTo(Object obj) {
        String objKey = ((IRDoc)obj).getKey();
        return this.key.compareTo(objKey);
    }

    public int compareTo(IRDoc doc) {
        return this.key.compareTo(doc.getKey());
    }
}

