/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.AbstractIndexer;
import dragon.ir.index.BasicIndexWriteController;
import dragon.ir.index.IRSection;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.TripleExtractor;
import dragon.onlinedb.Article;
import java.util.ArrayList;

public class BasicIndexer
extends AbstractIndexer {
    private BasicIndexWriteController charWriter;
    private BasicIndexWriteController cptWriter;
    private TripleExtractor te;
    private ConceptExtractor ce;
    private int minArticleSize;
    private boolean[] remainingSections;

    public BasicIndexer(TripleExtractor te, boolean useConcept, String indexFolder) {
        super(true);
        this.te = te;
        this.remainingSections = new boolean[4];
        this.minArticleSize = 5;
        if (useConcept) {
            this.cptWriter = new BasicIndexWriteController(indexFolder, this.relationSupported, true);
        } else {
            this.charWriter = new BasicIndexWriteController(indexFolder, this.relationSupported, false);
        }
    }

    public BasicIndexer(TripleExtractor te, String charIndexFolder, String cptIndexFolder) {
        super(true);
        this.te = te;
        this.remainingSections = new boolean[4];
        this.minArticleSize = 5;
        if (cptIndexFolder != null) {
            this.cptWriter = new BasicIndexWriteController(cptIndexFolder, this.relationSupported, true);
        }
        if (charIndexFolder != null) {
            this.charWriter = new BasicIndexWriteController(charIndexFolder, this.relationSupported, false);
        }
    }

    public BasicIndexer(ConceptExtractor ce, boolean useConcept, String indexFolder) {
        super(false);
        this.ce = ce;
        this.remainingSections = new boolean[4];
        if (useConcept) {
            this.cptWriter = new BasicIndexWriteController(indexFolder, this.relationSupported, true);
        } else {
            this.charWriter = new BasicIndexWriteController(indexFolder, this.relationSupported, false);
        }
    }

    public BasicIndexer(ConceptExtractor ce, String charIndexFolder, String cptIndexFolder) {
        super(false);
        this.ce = ce;
        this.remainingSections = new boolean[4];
        if (cptIndexFolder != null) {
            this.cptWriter = new BasicIndexWriteController(cptIndexFolder, this.relationSupported, true);
        }
        if (charIndexFolder != null) {
            this.charWriter = new BasicIndexWriteController(charIndexFolder, this.relationSupported, false);
        }
    }

    @Override
    public void close() {
        this.initialized = false;
        if (this.charWriter != null) {
            this.charWriter.close();
            this.charWriter = null;
        }
        if (this.cptWriter != null) {
            this.cptWriter.close();
            this.cptWriter = null;
        }
    }

    @Override
    public boolean indexed(String docKey) {
        if (this.charWriter != null) {
            return this.charWriter.indexed(docKey);
        }
        if (this.cptWriter != null) {
            return this.cptWriter.indexed(docKey);
        }
        return true;
    }

    public void setMinArticleSize(int minSize) {
        this.minArticleSize = minSize;
    }

    public void setSectionIndexOption(boolean all, boolean title, boolean abt, boolean body, boolean meta) {
        if (all) {
            this.addSection(new IRSection(0));
        }
        boolean bl = this.remainingSections[0] = !title;
        if (title) {
            this.addSection(new IRSection(1));
        }
        boolean bl2 = this.remainingSections[1] = !abt;
        if (abt) {
            this.addSection(new IRSection(2));
        }
        boolean bl3 = this.remainingSections[2] = !body;
        if (body) {
            this.addSection(new IRSection(3));
        }
        boolean bl4 = this.remainingSections[3] = !meta;
        if (meta) {
            this.addSection(new IRSection(4));
        }
    }

    @Override
    protected void initDocIndexing() {
        if (this.te != null) {
            this.te.initDocExtraction();
        }
        if (this.ce != null) {
            this.ce.initDocExtraction();
        }
    }

    @Override
    protected boolean extract(String content, ArrayList conceptList, ArrayList relationList) {
        try {
            if (content == null || content.length() < this.minArticleSize) {
                return true;
            }
            boolean ret = this.te.extractFromDoc(content);
            if (ret) {
                if (this.te.getConceptList() != null) {
                    conceptList.addAll(this.te.getConceptList());
                }
                if (this.te.getTripleList() != null) {
                    relationList.addAll(this.te.getTripleList());
                }
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean extract(String content, ArrayList conceptList) {
        try {
            if (content == null || content.length() < this.minArticleSize) {
                return true;
            }
            if (this.ce.extractFromDoc(content) != null) {
                conceptList.addAll(this.ce.getConceptList());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected String getSection(Article paper, int sectionID) {
        switch (sectionID) {
            case 1: {
                return paper.getTitle();
            }
            case 2: {
                return paper.getAbstract();
            }
            case 3: {
                return paper.getBody();
            }
            case 4: {
                return paper.getMeta();
            }
        }
        return null;
    }

    @Override
    protected String getRemainingSections(Article paper) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.remainingSections.length; ++i) {
            String section;
            if (!this.remainingSections[i] || (section = this.getSection(paper, i + 1)) == null || section.length() < this.minArticleSize) continue;
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(section);
        }
        return sb.toString();
    }

    @Override
    protected void write(int sectionID, ArrayList conceptList) {
        if (this.charWriter != null) {
            this.charWriter.write(sectionID, conceptList);
        }
        if (this.cptWriter != null) {
            this.cptWriter.write(sectionID, conceptList);
        }
    }

    @Override
    protected void write(int sectionID, ArrayList conceptList, ArrayList relationList) {
        if (this.charWriter != null) {
            this.charWriter.write(sectionID, conceptList, relationList);
        }
        if (this.cptWriter != null) {
            this.cptWriter.write(sectionID, conceptList, relationList);
        }
    }

    @Override
    protected void initIndex() {
        if (this.charWriter != null) {
            this.charWriter.initialize();
        }
        if (this.cptWriter != null) {
            this.cptWriter.initialize();
        }
    }

    @Override
    protected void initSectionWrite(IRSection section) {
        if (this.charWriter != null) {
            this.charWriter.addSection(section.copy());
        }
        if (this.cptWriter != null) {
            this.cptWriter.addSection(section.copy());
        }
    }

    @Override
    protected boolean setDoc(String docKey) {
        boolean ret = true;
        if (this.charWriter != null) {
            ret = this.charWriter.setDoc(docKey);
        }
        if (ret && this.cptWriter != null) {
            ret = this.cptWriter.setDoc(docKey);
        }
        return ret;
    }
}

