/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.AbstractIndexWriter;
import dragon.ir.index.BasicIRDocIndexList;
import dragon.ir.index.BasicIRRelationIndexList;
import dragon.ir.index.BasicIRTermIndexList;
import dragon.ir.index.FileIndex;
import dragon.ir.index.IRCollection;
import dragon.ir.index.TransposeIRMatrix;
import dragon.matrix.IntSuperSparseMatrix;
import java.io.File;

public class BasicIndexWriter
extends AbstractIndexWriter {
    private FileIndex fileIndex;

    public BasicIndexWriter(String directory, boolean relationSupported) {
        super(relationSupported);
        this.fileIndex = new FileIndex(directory, relationSupported);
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.doc_in_cache = 0;
        this.collection = new IRCollection();
        this.collection.load(this.fileIndex.getCollectionFilename());
        this.docIndexList = new BasicIRDocIndexList(this.fileIndex.getDocIndexListFilename(), true);
        this.termIndexList = new BasicIRTermIndexList(this.fileIndex.getTermIndexListFilename(), true);
        this.doctermMatrix = new IntSuperSparseMatrix(this.fileIndex.getDocTermIndexFilename(), this.fileIndex.getDocTermFilename(), false, false);
        ((IntSuperSparseMatrix)this.doctermMatrix).setFlushInterval(Integer.MAX_VALUE);
        if (this.relationSupported) {
            this.relationIndexList = new BasicIRRelationIndexList(this.fileIndex.getRelationIndexListFilename(), true);
            this.docrelationMatrix = new IntSuperSparseMatrix(this.fileIndex.getDocRelationIndexFilename(), this.fileIndex.getDocRelationFilename(), false, false);
            ((IntSuperSparseMatrix)this.docrelationMatrix).setFlushInterval(Integer.MAX_VALUE);
        }
        this.initialized = true;
    }

    @Override
    public void flush() {
        this.doc_in_cache = 0;
        this.collection.setDocNum(this.docIndexList.size());
        this.collection.setTermNum(this.termIndexList.size());
        ((IntSuperSparseMatrix)this.doctermMatrix).flush();
        if (this.relationSupported) {
            this.collection.setRelationNum(this.relationIndexList.size());
            ((IntSuperSparseMatrix)this.docrelationMatrix).flush();
        }
    }

    @Override
    public void close() {
        this.flush();
        this.collection.save(this.fileIndex.getCollectionFilename());
        this.docIndexList.close();
        this.termIndexList.close();
        this.doctermMatrix.finalizeData();
        this.doctermMatrix.close();
        if (this.relationSupported) {
            this.relationIndexList.close();
            this.docrelationMatrix.finalizeData();
            this.docrelationMatrix.close();
        }
        TransposeIRMatrix trans = new TransposeIRMatrix();
        trans.genTermDocMatrix(this.fileIndex.getDirectory());
        if (this.relationSupported) {
            trans.genRelationDocMatrix(this.fileIndex.getDirectory());
        }
    }

    @Override
    public void clean() {
        File file = new File(this.fileIndex.getDirectory());
        file.delete();
        file.mkdir();
    }
}

