/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.AbstractIndexWriteController;
import dragon.ir.index.BasicIndexWriter;
import dragon.ir.index.FileIndex;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IRSection;
import dragon.ir.index.IRTerm;
import dragon.nlp.SimpleElementList;
import dragon.nlp.SimplePairList;
import java.util.ArrayList;

public class BasicIndexWriteController
extends AbstractIndexWriteController {
    private static final int MAX_SEC = 10;
    private FileIndex fileIndex;
    private IRSection[] arrSections;

    public BasicIndexWriteController(String directory, boolean relationSupported, boolean indexConceptEntry) {
        super(relationSupported, indexConceptEntry);
        this.fileIndex = new FileIndex(directory, relationSupported);
        this.arrSections = new IRSection[10];
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.processedDoc = 0;
        this.docKeyList = new SimpleElementList(this.fileIndex.getDocKeyListFilename(), true);
        this.termKeyList = new SimpleElementList(this.fileIndex.getTermKeyListFilename(), true);
        if (this.relationSupported) {
            this.relationKeyList = new SimplePairList(this.fileIndex.getRelationKeyListFilename(), true);
        }
        for (int i = 0; i < this.arrSections.length; ++i) {
            if (this.arrSections[i] == null || this.arrSections[i].getIndexWriter() == null) continue;
            this.arrSections[i].getIndexWriter().initialize();
        }
        this.initialized = true;
    }

    public boolean addSection(IRSection section) {
        if (section.getSectionID() > 10) {
            return false;
        }
        BasicIndexWriter cur = new BasicIndexWriter(this.fileIndex.getDirectory() + "/" + section.getSectionName(), this.relationSupported);
        cur.initialize();
        section.setIndexWriter(cur);
        this.arrSections[section.getSectionID()] = section;
        return true;
    }

    public void flush() {
        for (int i = 0; i < 10; ++i) {
            if (this.arrSections[i] == null) continue;
            this.arrSections[i].getIndexWriter().flush();
        }
    }

    public void close() {
        this.docKeyList.close();
        this.termKeyList.close();
        if (this.relationSupported) {
            this.relationKeyList.close();
        }
        for (int i = 0; i < 10; ++i) {
            if (this.arrSections[i] == null) continue;
            this.arrSections[i].getIndexWriter().close();
        }
    }

    public boolean write(int section, ArrayList conceptList) {
        try {
            if (this.arrSections[section] == null || this.curDocKey == null) {
                return false;
            }
            IRDoc curDoc = new IRDoc(this.curDocKey);
            curDoc.setIndex(this.curDocIndex);
            IRTerm[] arrTerms = this.getIRTermArray(this.generateIRTermList(conceptList), curDoc);
            return this.arrSections[section].getIndexWriter().write(curDoc, arrTerms);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean write(int section, ArrayList conceptList, ArrayList tripleList) {
        try {
            if (this.arrSections[section] == null || this.curDocKey == null) {
                return false;
            }
            IRDoc curDoc = new IRDoc(this.curDocKey);
            curDoc.setIndex(this.curDocIndex);
            IRTerm[] arrTerms = this.getIRTermArray(this.generateIRTermList(conceptList), curDoc);
            IRRelation[] arrRelations = this.getIRRelationArray(this.generateIRRelationList(tripleList), curDoc);
            return this.arrSections[section].getIndexWriter().write(curDoc, arrTerms, arrRelations);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

