/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRSignature;
import dragon.ir.index.IRSignatureIndexList;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IRTermIndexList;
import dragon.util.ByteArrayConvert;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;

public class BasicIRTermIndexList
implements IRTermIndexList,
IRSignatureIndexList {
    private RandomAccessFile raf;
    private ArrayList indexList;
    private int elementLength;
    private boolean writingMode;
    private String indexlistFilename;
    private int termNum;
    private byte[] buf;

    public BasicIRTermIndexList(String filename, boolean writingMode) {
        try {
            this.elementLength = 12;
            this.writingMode = writingMode;
            this.indexlistFilename = filename;
            if (writingMode) {
                this.raf = null;
                this.indexList = this.loadTermIndexList(filename);
            } else {
                this.raf = new RandomAccessFile(filename, "r");
                this.buf = new byte[this.elementLength];
                this.termNum = this.raf.length() > 0L ? this.raf.readInt() : 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public IRSignature getIRSignature(int index) {
        return this.get(index);
    }

    @Override
    public IRTerm get(int index) {
        try {
            if (this.writingMode || index >= this.termNum) {
                return null;
            }
            this.raf.seek(index * this.elementLength + 4);
            this.raf.read(this.buf);
            return this.getIRTermFromByteArray(this.buf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean add(IRTerm curTerm) {
        if (!this.writingMode) {
            return false;
        }
        if (curTerm.getIndex() < this.indexList.size()) {
            IRTerm oldTerm = (IRTerm)this.indexList.get(curTerm.getIndex());
            oldTerm.addFrequency(curTerm.getFrequency());
            oldTerm.setDocFrequency(oldTerm.getDocFrequency() + curTerm.getDocFrequency());
        } else {
            for (int i = this.indexList.size(); i < curTerm.getIndex(); ++i) {
                this.indexList.add(new IRTerm(i, 0, 0));
            }
            curTerm = curTerm.copy();
            curTerm.setKey(null);
            this.indexList.add(curTerm);
        }
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.writingMode) {
                this.saveTermIndexList(this.indexlistFilename, this.indexList);
                this.indexList.clear();
            } else if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int size() {
        if (this.writingMode) {
            return this.indexList.size();
        }
        return this.termNum;
    }

    private ArrayList loadTermIndexList(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                return new ArrayList();
            }
            System.out.println(new Date() + " Loading Term List...");
            FastBinaryReader fbr = new FastBinaryReader(filename);
            int total = fbr.readInt();
            ArrayList<IRTerm> list = new ArrayList<IRTerm>(total);
            for (int i = 0; i < total; ++i) {
                IRTerm cur = new IRTerm(fbr.readInt(), fbr.readInt(), fbr.readInt());
                list.add(cur);
            }
            fbr.close();
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void saveTermIndexList(String filename, ArrayList list) {
        try {
            if (list == null) {
                return;
            }
            System.out.println(new Date() + " Saving Term Index List...");
            FastBinaryWriter fbw = new FastBinaryWriter(filename);
            fbw.writeInt(list.size());
            for (int i = 0; i < list.size(); ++i) {
                IRTerm cur = (IRTerm)list.get(i);
                fbw.writeInt(cur.getIndex());
                fbw.writeInt(cur.getFrequency());
                fbw.writeInt(cur.getDocFrequency());
                if (i % 100000 != 0) continue;
                fbw.flush();
            }
            fbw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private IRTerm getIRTermFromByteArray(byte[] array) {
        return new IRTerm(ByteArrayConvert.toInt(array, 0), ByteArrayConvert.toInt(array, 4), ByteArrayConvert.toInt(array, 8));
    }
}

