/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRDocIndexList;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IRRelationIndexList;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IRTermIndexList;
import dragon.ir.index.IndexWriter;
import dragon.matrix.IntSparseMatrix;

public abstract class AbstractIndexWriter
implements IndexWriter {
    protected static int doc_cache_size = 5000;
    protected IRTermIndexList termIndexList;
    protected IRRelationIndexList relationIndexList;
    protected IRDocIndexList docIndexList;
    protected IntSparseMatrix doctermMatrix;
    protected IntSparseMatrix docrelationMatrix;
    protected IRCollection collection;
    protected int doc_in_cache;
    protected boolean relationSupported;
    protected boolean initialized;

    public AbstractIndexWriter(boolean relationSupported) {
        this.relationSupported = relationSupported;
        this.doc_in_cache = 0;
    }

    @Override
    public int size() {
        return this.docIndexList.size();
    }

    @Override
    public synchronized boolean write(IRDoc curDoc, IRTerm[] arrTerms, IRRelation[] arrRelations) {
        try {
            int i;
            if (!this.relationSupported) {
                return false;
            }
            if (!this.docIndexList.add(curDoc)) {
                System.out.println("#" + curDoc.getKey() + " is alrady indexed");
                return false;
            }
            if (this.doc_in_cache > doc_cache_size) {
                this.flush();
            }
            ++this.doc_in_cache;
            for (i = 0; i < arrTerms.length; ++i) {
                arrTerms[i].setDocFrequency(1);
                this.doctermMatrix.add(curDoc.getIndex(), arrTerms[i].getIndex(), arrTerms[i].getFrequency());
                this.termIndexList.add(arrTerms[i]);
            }
            this.collection.addTermCount(curDoc.getTermCount());
            for (i = 0; i < arrRelations.length; ++i) {
                arrRelations[i].setDocFrequency(1);
                this.docrelationMatrix.add(curDoc.getIndex(), arrRelations[i].getIndex(), arrRelations[i].getFrequency());
                this.relationIndexList.add(arrRelations[i]);
            }
            this.collection.addRelationCount(curDoc.getRelationCount());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public synchronized boolean write(IRDoc curDoc, IRTerm[] arrTerms) {
        try {
            if (!this.docIndexList.add(curDoc)) {
                System.out.println("#" + curDoc.getKey() + " is already indexed");
                return false;
            }
            if (this.doc_in_cache > doc_cache_size) {
                this.flush();
            }
            ++this.doc_in_cache;
            for (int i = 0; i < arrTerms.length; ++i) {
                arrTerms[i].setDocFrequency(1);
                this.doctermMatrix.add(curDoc.getIndex(), arrTerms[i].getIndex(), arrTerms[i].getFrequency());
                this.termIndexList.add(arrTerms[i]);
            }
            this.collection.addTermCount(curDoc.getTermCount());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

