/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IRTerm;
import dragon.nlp.Concept;
import dragon.nlp.SimpleElementList;
import dragon.nlp.SimplePairList;
import dragon.nlp.Triple;
import dragon.nlp.compare.IndexComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public abstract class AbstractIndexWriteController {
    protected SimpleElementList termKeyList;
    protected SimpleElementList docKeyList;
    protected SimplePairList relationKeyList;
    protected int curDocIndex;
    protected String curDocKey;
    protected int processedDoc;
    protected boolean relationSupported;
    protected boolean initialized;
    private SortedArray termList;
    private SortedArray relationList;
    private boolean indexConceptEntry;

    public AbstractIndexWriteController(boolean relationSupported, boolean indexConceptEntry) {
        this.relationSupported = relationSupported;
        this.indexConceptEntry = indexConceptEntry;
        this.processedDoc = 0;
        this.initialized = false;
        this.termList = new SortedArray();
        if (relationSupported) {
            this.relationList = new SortedArray();
        }
    }

    public abstract void initialize();

    public boolean indexed(String docKey) {
        return this.docKeyList.contains(docKey);
    }

    public int size() {
        return this.processedDoc;
    }

    public boolean isRelationSupported() {
        return this.relationSupported;
    }

    public boolean setDoc(String docKey) {
        this.curDocIndex = this.docKeyList.add(docKey);
        this.termList.clear();
        if (this.relationSupported) {
            this.relationList.clear();
        }
        if (this.curDocIndex == this.docKeyList.size() - 1) {
            this.curDocKey = docKey;
            ++this.processedDoc;
            return true;
        }
        this.curDocKey = null;
        return false;
    }

    protected IRTerm[] getIRTermArray(ArrayList irtermList, IRDoc curDoc) {
        IRTerm[] arrTerms = new IRTerm[irtermList.size()];
        curDoc.setTermNum(arrTerms.length);
        int count = 0;
        for (int i = 0; i < irtermList.size(); ++i) {
            arrTerms[i] = (IRTerm)irtermList.get(i);
            count += arrTerms[i].getFrequency();
        }
        curDoc.setTermCount(count);
        return arrTerms;
    }

    protected IRRelation[] getIRRelationArray(ArrayList irRelationList, IRDoc curDoc) {
        IRRelation[] arrRelations = new IRRelation[irRelationList.size()];
        curDoc.setRelationNum(arrRelations.length);
        int count = 0;
        for (int i = 0; i < irRelationList.size(); ++i) {
            arrRelations[i] = (IRRelation)irRelationList.get(i);
            count += arrRelations[i].getFrequency();
        }
        curDoc.setRelationCount(count);
        return arrRelations;
    }

    protected SortedArray generateIRTermList(ArrayList termList) {
        SortedArray newList = new SortedArray();
        for (int i = 0; i < termList.size(); ++i) {
            IRTerm curIRTerm = this.getIRTerm((Concept)termList.get(i));
            if (newList.add(curIRTerm)) continue;
            ((IRTerm)newList.get(newList.insertedPos())).addFrequency(curIRTerm.getFrequency());
        }
        return newList;
    }

    protected SortedArray generateIRRelationList(ArrayList tripleList) {
        SortedArray newList = new SortedArray(new IndexComparator());
        for (int i = 0; i < tripleList.size(); ++i) {
            IRRelation curIRRelation = this.getIRRelation((Triple)tripleList.get(i));
            if (newList.add(curIRRelation)) continue;
            ((IRRelation)newList.get(newList.insertedPos())).addFrequency(curIRRelation.getFrequency());
        }
        return newList;
    }

    private IRRelation getIRRelation(Triple triple) {
        int second;
        int first = this.getIRTerm(triple.getFirstConcept()).getIndex();
        IRRelation cur = first > (second = this.getIRTerm(triple.getSecondConcept()).getIndex()) ? new IRRelation(second, first, triple.getFrequency()) : new IRRelation(first, second, triple.getFrequency());
        if (this.relationList.add(cur)) {
            int index = this.relationKeyList.add(cur.getFirstTerm(), cur.getSecondTerm());
            cur.setIndex(index);
        } else {
            cur.setIndex(((IRRelation)this.relationList.get(this.relationList.insertedPos())).getIndex());
        }
        return cur;
    }

    private IRTerm getIRTerm(Concept concept) {
        IRTerm cur = this.indexConceptEntry ? new IRTerm(new String(concept.getEntryID()), -1, concept.getFrequency()) : new IRTerm(new String(concept.getName()), -1, concept.getFrequency());
        if (this.termList.add(cur)) {
            int index = this.termKeyList.add(cur.getKey());
            cur.setIndex(index);
        } else {
            cur.setIndex(((IRTerm)this.termList.get(this.termList.insertedPos())).getIndex());
        }
        return cur;
    }
}

