/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.featurefilter;

import dragon.ir.clustering.featurefilter.AbstractFeatureFilter;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.util.MathUtil;
import java.util.ArrayList;

public class DocFrequencyFilter
extends AbstractFeatureFilter {
    private int minDocFrequency;

    public DocFrequencyFilter(int minDocFrequency) {
        this.minDocFrequency = minDocFrequency;
    }

    @Override
    protected int[] getSelectedFeatures(IndexReader indexReader, IRDoc[] docSet) {
        int i;
        int termNum = indexReader.getCollection().getTermNum();
        int[] arrDocFreq = docSet != null && (double)docSet.length < (double)indexReader.getCollection().getDocNum() * 0.67 ? this.computeTermCount(indexReader, docSet) : null;
        ArrayList<IRTerm> list = new ArrayList<IRTerm>(termNum);
        for (i = 0; i < termNum; ++i) {
            IRTerm curTerm;
            if (arrDocFreq != null && arrDocFreq[i] == 0 || (curTerm = indexReader.getIRTerm(i)).getDocFrequency() < this.minDocFrequency) continue;
            list.add(curTerm);
        }
        int[] featureMap = new int[list.size()];
        for (i = 0; i < featureMap.length; ++i) {
            featureMap[i] = ((IRTerm)list.get(i)).getIndex();
        }
        return featureMap;
    }

    private int[] computeTermCount(IndexReader indexReader, IRDoc[] arrDoc) {
        int[] buf = new int[indexReader.getCollection().getTermNum()];
        MathUtil.initArray(buf, 0);
        for (int j = 0; j < arrDoc.length; ++j) {
            int[] arrIndex = indexReader.getTermIndexList(arrDoc[j].getIndex());
            for (int k = 0; k < arrIndex.length; ++k) {
                int n = arrIndex[k];
                buf[n] = buf[n] + 1;
            }
        }
        return buf;
    }
}

