/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.docdistance;

import dragon.ir.clustering.docdistance.AbstractDocDistance;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.matrix.DoubleSparseMatrix;

public class KLDivDocDistance
extends AbstractDocDistance {
    private double bkgCoefficient = 0.1;
    private double normThreshold;
    private double[] arrBkgModel;
    private boolean norm;

    public KLDivDocDistance(DoubleSparseMatrix docModelMatrix) {
        this(docModelMatrix, 0.0);
    }

    public KLDivDocDistance(DoubleSparseMatrix doctermMatrix, double normThreshold) {
        super(doctermMatrix);
        int termNum = this.matrix.columns();
        this.arrBkgModel = new double[termNum];
        for (int i = 0; i < termNum; ++i) {
            this.arrBkgModel[i] = this.bkgCoefficient / (double)termNum;
        }
        if (normThreshold > 0.0) {
            this.norm = true;
            this.normThreshold = normThreshold;
        } else {
            this.norm = false;
            this.normThreshold = 0.0;
        }
    }

    public KLDivDocDistance(IndexReader indexReader, DoubleSparseMatrix docModelMatrix) {
        this(indexReader, docModelMatrix, 0.0);
    }

    public KLDivDocDistance(IndexReader indexReader, DoubleSparseMatrix doctermMatrix, double normThreshold) {
        super(doctermMatrix);
        int termNum = indexReader.getCollection().getTermNum();
        this.arrBkgModel = new double[termNum];
        double totalTermCount = indexReader.getCollection().getTermCount();
        for (int i = 0; i < termNum; ++i) {
            this.arrBkgModel[i] = (double)indexReader.getIRTerm(i).getFrequency() / totalTermCount * this.bkgCoefficient;
        }
        if (normThreshold > 0.0) {
            this.norm = true;
            this.normThreshold = normThreshold;
        } else {
            this.norm = false;
            this.normThreshold = 0.0;
        }
    }

    @Override
    public double getDistance(IRDoc first, IRDoc second) {
        int[] arrFirstIndex = this.matrix.getNonZeroColumnsInRow(first.getIndex());
        double[] arrFirstScore = this.matrix.getNonZeroDoubleScoresInRow(first.getIndex());
        int firstCount = this.matrix.getNonZeroNumInRow(first.getIndex());
        int[] arrSecondIndex = this.matrix.getNonZeroColumnsInRow(second.getIndex());
        double[] arrSecondScore = this.matrix.getNonZeroDoubleScoresInRow(second.getIndex());
        int secondCount = this.matrix.getNonZeroNumInRow(second.getIndex());
        double distance = 0.0;
        int j = 0;
        for (int i = 0; i < firstCount; ++i) {
            while (j < secondCount && arrSecondIndex[j] < arrFirstIndex[i]) {
                ++j;
            }
            double secondProb = j >= secondCount || arrSecondIndex[j] != arrFirstIndex[i] ? this.arrBkgModel[arrFirstIndex[i]] : (1.0 - this.bkgCoefficient) * arrSecondScore[j] + this.arrBkgModel[arrFirstIndex[i]];
            double firstProb = (1.0 - this.bkgCoefficient) * arrFirstScore[i] + this.arrBkgModel[arrFirstIndex[i]];
            distance += firstProb * Math.log(firstProb / secondProb);
        }
        if (this.norm) {
            if (distance >= this.normThreshold) {
                return 1.0;
            }
            return distance / this.normThreshold;
        }
        return distance;
    }
}

