/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.docdistance;

import dragon.ir.clustering.docdistance.AbstractDocDistance;
import dragon.ir.index.IRDoc;
import dragon.matrix.SparseMatrix;

public class EuclideanDocDistance
extends AbstractDocDistance {
    public EuclideanDocDistance(SparseMatrix doctermMatrix) {
        super(doctermMatrix);
    }

    @Override
    public double getDistance(IRDoc first, IRDoc second) {
        double[] firstScoreList = this.matrix.getNonZeroDoubleScoresInRow(first.getIndex());
        double[] secondScoreList = this.matrix.getNonZeroDoubleScoresInRow(second.getIndex());
        int[] firstIndexList = this.matrix.getNonZeroColumnsInRow(first.getIndex());
        int[] secondIndexList = this.matrix.getNonZeroColumnsInRow(second.getIndex());
        int firstNum = firstScoreList.length;
        int secondNum = secondScoreList.length;
        int x = 0;
        int y = 0;
        double sum = 0.0;
        while (x < firstNum && y < secondNum) {
            if (firstIndexList[x] < secondIndexList[y]) {
                if (this.featureFilter == null || this.featureFilter.map(firstIndexList[x]) >= 0) {
                    sum += firstScoreList[x] * firstScoreList[x];
                }
                ++x;
                continue;
            }
            if (firstIndexList[x] == secondIndexList[y]) {
                if (this.featureFilter == null || this.featureFilter.map(firstIndexList[x]) >= 0) {
                    sum += (firstScoreList[x] - secondScoreList[y]) * (firstScoreList[x] - secondScoreList[y]);
                }
                ++x;
                ++y;
                continue;
            }
            if (this.featureFilter == null || this.featureFilter.map(secondIndexList[y]) >= 0) {
                sum += secondScoreList[y] * secondScoreList[y];
            }
            ++y;
        }
        while (x < firstNum) {
            if (this.featureFilter == null || this.featureFilter.map(firstIndexList[x]) >= 0) {
                sum += firstScoreList[x] * firstScoreList[x];
            }
            ++x;
        }
        while (y < secondNum) {
            if (this.featureFilter == null || this.featureFilter.map(secondIndexList[y]) >= 0) {
                sum += secondScoreList[y] * secondScoreList[y];
            }
            ++y;
        }
        return Math.sqrt(sum);
    }
}

