/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.clustermodel;

import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.clustermodel.AbstractClusterModel;
import dragon.ir.clustering.featurefilter.FeatureFilter;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.kngbase.KnowledgeBase;
import dragon.matrix.DoubleSparseMatrix;
import dragon.util.MathUtil;

public class MultinomialClusterModel
extends AbstractClusterModel {
    private static final int SMOOTH_LAPLACIAN = 0;
    private static final int SMOOTH_BKG = 1;
    private static final int SMOOTH_TRANS = 2;
    private IndexReader indexReader;
    private IndexReader topicIndexReader;
    private DoubleSparseMatrix topicTransMatrix;
    private double[][] arrClusterModel;
    private double[] arrBkgModel;
    private double bkgCoefficient;
    private double transCoefficient;
    private int[] topicMap;
    private int[] termMap;
    private int featureNum;
    private int smoothingMethod;

    public MultinomialClusterModel(int clusterNum, IndexReader indexReader) {
        super(clusterNum);
        this.indexReader = indexReader;
        this.smoothingMethod = 0;
        this.featureNum = indexReader.getCollection().getTermNum();
    }

    public MultinomialClusterModel(int clusterNum, IndexReader indexReader, double bkgCoefficient) {
        super(clusterNum);
        this.indexReader = indexReader;
        this.bkgCoefficient = bkgCoefficient;
        this.smoothingMethod = 1;
        this.featureNum = indexReader.getCollection().getTermNum();
    }

    public MultinomialClusterModel(int clusterNum, IndexReader indexReader, IndexReader topicIndexReader, DoubleSparseMatrix topicTransMatrix, double transCoefficient, double bkgCoefficient) {
        super(clusterNum);
        int i;
        this.indexReader = indexReader;
        this.topicIndexReader = topicIndexReader;
        this.topicTransMatrix = topicTransMatrix;
        this.transCoefficient = transCoefficient;
        this.bkgCoefficient = bkgCoefficient;
        this.smoothingMethod = 2;
        this.featureNum = indexReader.getCollection().getTermNum();
        this.topicMap = new int[topicIndexReader.getCollection().getTermNum()];
        for (i = 0; i < this.topicMap.length; ++i) {
            this.topicMap[i] = i;
        }
        this.termMap = new int[indexReader.getCollection().getTermNum()];
        for (i = 0; i < this.termMap.length; ++i) {
            this.termMap[i] = i;
        }
    }

    public MultinomialClusterModel(int clusterNum, IndexReader indexReader, IndexReader topicIndexReader, KnowledgeBase kngBase, double transCoefficient, double bkgCoefficient) {
        super(clusterNum);
        int i;
        this.indexReader = indexReader;
        this.topicIndexReader = topicIndexReader;
        this.topicTransMatrix = kngBase.getKnowledgeMatrix();
        this.transCoefficient = transCoefficient;
        this.bkgCoefficient = bkgCoefficient;
        this.smoothingMethod = 2;
        this.featureNum = indexReader.getCollection().getTermNum();
        this.topicMap = new int[topicIndexReader.getCollection().getTermNum()];
        for (i = 0; i < this.topicMap.length; ++i) {
            this.topicMap[i] = kngBase.getRowKeyList().search(topicIndexReader.getTermKey(i));
        }
        this.termMap = new int[kngBase.getColumnKeyList().size()];
        for (i = 0; i < this.termMap.length; ++i) {
            IRTerm curTerm = indexReader.getIRTerm(kngBase.getColumnKeyList().search(i));
            this.termMap[i] = curTerm == null ? -1 : curTerm.getIndex();
        }
    }

    public double getTranslationCoefficient() {
        return this.transCoefficient;
    }

    public void setTranslationCoefficient(double transCoefficient) {
        this.transCoefficient = transCoefficient;
    }

    public double getBackgroundCoefficient() {
        return this.bkgCoefficient;
    }

    public void setBackgroundCoefficient(double bkgCoefficient) {
        this.bkgCoefficient = bkgCoefficient;
    }

    @Override
    public void setFeatureFilter(FeatureFilter featureFilter) {
        this.featureFilter = featureFilter;
        this.featureNum = featureFilter != null ? featureFilter.getSelectedFeatureNum() : this.indexReader.getCollection().getTermNum();
    }

    @Override
    public double getDistance(IRDoc doc, int clusterID) {
        int[] arrIndex = this.indexReader.getTermIndexList(doc.getIndex());
        int[] arrFreq = this.indexReader.getTermFrequencyList(doc.getIndex());
        int len = arrIndex == null ? 0 : arrIndex.length;
        double sum = 0.0;
        for (int i = 0; i < len; ++i) {
            int newIndex = this.featureFilter == null ? arrIndex[i] : this.featureFilter.map(arrIndex[i]);
            if (newIndex < 0) continue;
            sum += (double)arrFreq[i] * this.arrClusterModel[clusterID][newIndex];
        }
        return -sum;
    }

    @Override
    public void setClusterNum(int clusterNum) {
        this.clusterNum = clusterNum;
    }

    @Override
    public void setDocCluster(DocCluster cluster) {
        if (this.arrClusterModel == null || this.arrClusterModel.length != this.clusterNum || this.arrClusterModel[0].length != this.featureNum) {
            this.arrClusterModel = new double[this.clusterNum][this.featureNum];
        }
        int[] arrCount = new int[this.featureNum];
        for (int i = 0; i < cluster.getDocNum(); ++i) {
            IRDoc curDoc = cluster.getDoc(i);
            int[] arrIndex = this.indexReader.getTermIndexList(curDoc.getIndex());
            int[] arrFreq = this.indexReader.getTermFrequencyList(curDoc.getIndex());
            int len = arrIndex == null ? 0 : arrIndex.length;
            for (int j = 0; j < len; ++j) {
                int newIndex = this.featureFilter == null ? arrIndex[j] : this.featureFilter.map(arrIndex[j]);
                if (newIndex < 0) continue;
                int n = newIndex;
                arrCount[n] = arrCount[n] + arrFreq[j];
            }
        }
        if (this.smoothingMethod == 0) {
            this.laplacianSmoothing(arrCount, cluster.getClusterID());
        } else if (this.smoothingMethod == 1) {
            this.backgroundSmoothing(arrCount, cluster.getClusterID());
        } else {
            this.translationSmoothing(arrCount, this.computeTranslationModel(cluster), cluster.getClusterID());
        }
    }

    private void translationSmoothing(int[] arrCount, double[] arrTransModel, int clusterID) {
        if (this.arrBkgModel == null || this.arrBkgModel.length != this.featureNum) {
            this.arrBkgModel = this.getBackgroundModel(this.indexReader);
        }
        double sum = this.getSummation(arrCount);
        double a = this.transCoefficient;
        double b = (1.0 - this.bkgCoefficient) * (1.0 - this.transCoefficient) / sum;
        double c = this.bkgCoefficient * (1.0 - this.transCoefficient);
        for (int i = 0; i < this.featureNum; ++i) {
            this.arrClusterModel[clusterID][i] = Math.log(arrTransModel[i] * a + (double)arrCount[i] * b + this.arrBkgModel[i] * c);
        }
    }

    private double[] computeTranslationModel(DocCluster cluster) {
        int termIndex;
        int topicIndex;
        int j;
        int[] arrIndex;
        int i;
        int topicNum = this.topicIndexReader.getCollection().getTermNum();
        int[] arrCount = new int[topicNum];
        int termNum = this.indexReader.getCollection().getTermNum();
        int docNum = this.topicIndexReader.getCollection().getDocNum();
        for (i = 0; i < cluster.getDocNum(); ++i) {
            IRDoc curDoc = cluster.getDoc(i);
            if (curDoc.getIndex() >= docNum) continue;
            arrIndex = this.topicIndexReader.getTermIndexList(curDoc.getIndex());
            int[] arrFreq = this.topicIndexReader.getTermFrequencyList(curDoc.getIndex());
            if (arrIndex == null) continue;
            for (j = 0; j < arrIndex.length; ++j) {
                int n = arrIndex[j];
                arrCount[n] = arrCount[n] + arrFreq[j];
            }
        }
        for (i = 0; i < this.topicMap.length; ++i) {
            topicIndex = this.topicMap[i];
            if (topicIndex < 0) {
                arrCount[i] = 0;
                continue;
            }
            if (topicIndex >= this.topicTransMatrix.rows()) {
                arrCount[i] = 0;
                continue;
            }
            if (this.topicTransMatrix.getNonZeroNumInRow(topicIndex) > 0) continue;
            arrCount[i] = 0;
        }
        double sum = MathUtil.sumArray(arrCount);
        double[] arrModel = new double[termNum];
        for (i = 0; i < topicNum; ++i) {
            if (arrCount[i] <= 0) continue;
            topicIndex = this.topicMap[i];
            double rate = (double)arrCount[i] / sum;
            arrIndex = this.topicTransMatrix.getNonZeroColumnsInRow(topicIndex);
            double[] arrScore = this.topicTransMatrix.getNonZeroDoubleScoresInRow(topicIndex);
            for (j = 0; j < arrIndex.length; ++j) {
                termIndex = this.termMap[arrIndex[j]];
                if (termIndex < 0) continue;
                int n = termIndex;
                arrModel[n] = arrModel[n] + rate * arrScore[j];
            }
        }
        if (arrModel.length == this.featureFilter.getSelectedFeatureNum()) {
            return arrModel;
        }
        double[] arrSelectedModel = new double[this.featureFilter.getSelectedFeatureNum()];
        sum = 0.0;
        for (i = 0; i < arrModel.length; ++i) {
            termIndex = this.featureFilter.map(i);
            if (termIndex < 0) continue;
            sum += arrModel[i];
            arrSelectedModel[termIndex] = arrModel[i];
        }
        for (i = 0; i < arrSelectedModel.length; ++i) {
            arrSelectedModel[i] = arrSelectedModel[i] / sum;
        }
        return arrSelectedModel;
    }

    private void backgroundSmoothing(int[] arrCount, int clusterID) {
        if (this.arrBkgModel == null || this.arrBkgModel.length != this.featureNum) {
            this.arrBkgModel = this.getBackgroundModel(this.indexReader);
        }
        double sum = this.getSummation(arrCount);
        for (int i = 0; i < this.featureNum; ++i) {
            this.arrClusterModel[clusterID][i] = Math.log((double)arrCount[i] / sum * (1.0 - this.bkgCoefficient) + this.bkgCoefficient * this.arrBkgModel[i]);
        }
    }

    private void laplacianSmoothing(int[] arrCount, int clusterID) {
        double sum = this.getSummation(arrCount) + (double)this.featureNum;
        for (int i = 0; i < this.featureNum; ++i) {
            this.arrClusterModel[clusterID][i] = Math.log(((double)arrCount[i] + 1.0) / sum);
        }
    }

    private double getSummation(int[] arrCount) {
        long sum = 0L;
        for (int i = 0; i < arrCount.length; ++i) {
            sum += (long)arrCount[i];
        }
        return sum;
    }

    private double[] getBackgroundModel(IndexReader reader) {
        int i;
        int termNum = reader.getCollection().getTermNum();
        double sum = 0.0;
        double[] arrModel = new double[this.featureNum];
        for (i = 0; i < termNum; ++i) {
            int newIndex = this.featureFilter == null ? i : this.featureFilter.map(i);
            if (newIndex < 0) continue;
            arrModel[newIndex] = reader.getIRTerm(i).getFrequency();
            sum += arrModel[newIndex];
        }
        for (i = 0; i < this.featureNum; ++i) {
            arrModel[i] = arrModel[i] / sum;
        }
        return arrModel;
    }
}

