/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.clustermodel;

import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.clustermodel.AbstractClusterModel;
import dragon.ir.index.IRDoc;
import dragon.matrix.SparseMatrix;

public class CosineClusterModel
extends AbstractClusterModel {
    private double[][] arrClusterVector;
    private double[] arrClusterVectorLen;
    private SparseMatrix matrix;

    public CosineClusterModel(int clusterNum, SparseMatrix doctermMatrix) {
        super(clusterNum);
        this.matrix = doctermMatrix;
        this.arrClusterVectorLen = new double[clusterNum];
    }

    @Override
    public void setClusterNum(int clusterNum) {
        this.clusterNum = clusterNum;
        this.arrClusterVectorLen = new double[clusterNum];
    }

    @Override
    public void setDocCluster(DocCluster cluster) {
        int i;
        int featureNum = this.featureFilter == null ? this.matrix.columns() : this.featureFilter.getSelectedFeatureNum();
        if (this.arrClusterVector == null || this.arrClusterVector.length != this.clusterNum || this.arrClusterVector[0].length != featureNum) {
            this.arrClusterVector = new double[this.clusterNum][featureNum];
        }
        int clusterID = cluster.getClusterID();
        double vectorLength = 0.0;
        for (i = 0; i < cluster.getDocNum(); ++i) {
            int[] indexList = this.matrix.getNonZeroColumnsInRow(cluster.getDoc(i).getIndex());
            double[] freqList = this.matrix.getNonZeroDoubleScoresInRow(cluster.getDoc(i).getIndex());
            for (int j = 0; j < indexList.length; ++j) {
                int newIndex = indexList[j];
                if (this.featureFilter != null) {
                    newIndex = this.featureFilter.map(newIndex);
                }
                if (newIndex < 0) continue;
                double[] dArray = this.arrClusterVector[clusterID];
                int n = newIndex;
                dArray[n] = dArray[n] + freqList[j];
            }
        }
        for (i = 0; i < this.arrClusterVector[clusterID].length; ++i) {
            if (this.arrClusterVector[clusterID][i] == 0.0) continue;
            this.arrClusterVector[clusterID][i] = this.arrClusterVector[clusterID][i] / (double)cluster.getDocNum();
            vectorLength += this.arrClusterVector[clusterID][i] * this.arrClusterVector[clusterID][i];
        }
        this.arrClusterVectorLen[clusterID] = Math.sqrt(vectorLength);
    }

    @Override
    public double getDistance(IRDoc doc, int clusterID) {
        double product = 0.0;
        double docLength = 0.0;
        int[] indexList = this.matrix.getNonZeroColumnsInRow(doc.getIndex());
        double[] freqList = this.matrix.getNonZeroDoubleScoresInRow(doc.getIndex());
        for (int i = 0; i < indexList.length; ++i) {
            int newIndex = indexList[i];
            if (this.featureFilter != null) {
                newIndex = this.featureFilter.map(newIndex);
            }
            if (newIndex < 0) continue;
            product += this.arrClusterVector[clusterID][newIndex] * freqList[i];
            docLength += freqList[i] * freqList[i];
        }
        if ((docLength = Math.sqrt(docLength)) == 0.0 || this.arrClusterVectorLen[clusterID] == 0.0) {
            return 1.0;
        }
        return 1.0 - product / this.arrClusterVectorLen[clusterID] / docLength;
    }
}

